/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import de.trustable.ca3s.core.config.ApplicationProperties;
import de.trustable.ca3s.core.config.DefaultProfileUtil;
import de.trustable.ca3s.core.security.provider.Ca3sFallbackBundleFactory;
import de.trustable.ca3s.core.security.provider.Ca3sKeyManagerProvider;
import de.trustable.ca3s.core.security.provider.Ca3sKeyStoreProvider;
import de.trustable.ca3s.core.security.provider.TimedRenewalCertMapHolder;
import de.trustable.util.JCAManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableConfigurationProperties(value={LiquibaseProperties.class, ApplicationProperties.class})
public class Ca3SApp
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Ca3SApp.class);
    private final Environment env;

    public Ca3SApp(Environment env) {
        this.env = env;
    }

    public void afterPropertiesSet() throws Exception {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("dev") && activeProfiles.contains("prod")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'prod' profiles at the same time.");
        }
        if (activeProfiles.contains("dev") && activeProfiles.contains("cloud")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'cloud' profiles at the same time.");
        }
    }

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{Ca3SApp.class});
        DefaultProfileUtil.addDefaultProfile((SpringApplication)app);
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        Ca3SApp.logApplicationStartup((Environment)env);
    }

    private static void logApplicationStartup(Environment env) {
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        String serverPort = env.getProperty("server.port");
        String contextPath = env.getProperty("server.servlet.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = "/";
        }
        String hostAddress = "localhost";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("The host name could not be determined, using `localhost` as fallback");
        }
        log.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}{}\n\tExternal: \t{}://{}:{}{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, serverPort, contextPath, protocol, hostAddress, serverPort, contextPath, env.getActiveProfiles()});
    }

    @Bean
    public TimedRenewalCertMapHolder registerJCEProvider() {
        JCAManager.getInstance();
        TimedRenewalCertMap certMap = new TimedRenewalCertMap(null, (BundleFactory)new Ca3sFallbackBundleFactory());
        Security.addProvider((Provider)new Ca3sKeyStoreProvider(certMap, "ca3s"));
        Security.addProvider((Provider)new Ca3sKeyManagerProvider(certMap));
        TimedRenewalCertMapHolder trcmh = new TimedRenewalCertMapHolder();
        trcmh.setCertMap(certMap);
        log.info("JCAManager and Provider initialized ...");
        return trcmh;
    }

    @Bean
    public UndertowServletWebServerFactory embeddedServletContainerFactory() {
        this.registerJCEProvider();
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new /* Unavailable Anonymous Inner Class!! */});
        return factory;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

