/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.scepservlet;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.web.scepservlet.ScepServletImpl;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
public class Ca3sSCEPServiceResource {
    private final ScepServletImpl scepServlet;
    private final PipelineRepository pipeRepo;
    private static final Logger LOGGER = LoggerFactory.getLogger(Ca3sSCEPServiceResource.class);

    @Autowired
    public Ca3sSCEPServiceResource(ScepServletImpl scepServlet, PipelineRepository pipeRepo) {
        this.scepServlet = scepServlet;
        this.pipeRepo = pipeRepo;
        LOGGER.info("in Ca3sSCEPServiceResource()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/scep/{realm}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public void handleSCEPRequest(@PathVariable(value="realm") String realm, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        List pipelineList = this.pipeRepo.findActiveByTypeUrl(PipelineType.SCEP, realm);
        if (pipelineList.isEmpty()) {
            LOGGER.info("no matching pipeline for scep request realm {}", (Object)realm);
            throw new ServletException("Request URL not found");
        }
        this.scepServlet.threadLocalPipeline.set((Pipeline)pipelineList.get(0));
        try {
            this.scepServlet.service(request, response);
        }
        finally {
            this.scepServlet.threadLocalPipeline.remove();
        }
        LOGGER.info("duration of scep processing " + (System.currentTimeMillis() - startTime));
    }
}

