/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeIdentifier;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeAuthorizationRepository;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.repository.AcmeIdentifierRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.dto.acme.IdentifierResponse;
import de.trustable.ca3s.core.service.dto.acme.IdentifiersResponse;
import de.trustable.ca3s.core.service.dto.acme.NewOrderResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import java.net.IDN;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

@Transactional
@Controller
@RequestMapping(value={"/acme/{realm}/newOrder"})
public class NewOrderController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(NewOrderController.class);
    private static final long DEFAULT_ORDER_VALID_DAYS = 5L;
    private final AcmeOrderRepository orderRepository;
    private final AcmeAuthorizationRepository authorizationRepository;
    private final AcmeChallengeRepository challengeRepository;
    private final AcmeIdentifierRepository identRepository;
    private final String resolverHost;

    public NewOrderController(AcmeOrderRepository orderRepository, AcmeAuthorizationRepository authorizationRepository, AcmeChallengeRepository challengeRepository, AcmeIdentifierRepository identRepository, @Value(value="${ca3s.dns.server:}") String resolverHost) {
        this.orderRepository = orderRepository;
        this.authorizationRepository = authorizationRepository;
        this.challengeRepository = challengeRepository;
        this.identRepository = identRepository;
        this.resolverHost = resolverHost;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> consumingPostedJoseJson(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received consumingPostedJoseJson request ");
        return this.consumeWithConverter(requestBody, realm);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jws"})
    public ResponseEntity<?> consumingPostedJws(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received consumingPostedJws request ");
        return this.consumeWithConverter(requestBody, realm);
    }

    public ResponseEntity<?> consumeWithConverter(@RequestBody String requestBody, String realm) {
        LOG.info("Received NewOrder request for realm {}", (Object)realm);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            IdentifiersResponse newIdentifiers = this.jwtUtil.getIdentifiers(context.getJwtClaims());
            LOG.debug("New Order reads Identifiers: " + newIdentifiers);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            AcmeOrder orderDao = new AcmeOrder();
            orderDao.setOrderId(Long.valueOf(this.generateId()));
            orderDao.setAccount(acctDao);
            orderDao.setStatus(AcmeOrderStatus.PENDING);
            Instant now = Instant.now();
            orderDao.setExpires(now.plus(5L, ChronoUnit.DAYS));
            orderDao.setNotBefore(now);
            orderDao.setNotAfter(orderDao.getExpires());
            this.orderRepository.save((Object)orderDao);
            HashSet<Object> identifiers = new HashSet<Object>();
            for (IdentifierResponse ident : newIdentifiers.getIdentifiers()) {
                AcmeIdentifier identDao = new AcmeIdentifier();
                identDao.setAcmeIdentifierId(Long.valueOf(this.generateId()));
                identDao.setOrder(orderDao);
                identDao.setType(ident.getType());
                identDao.setValue(ident.getValue());
                identifiers.add(identDao);
            }
            this.identRepository.saveAll(identifiers);
            orderDao.setAcmeIdentifiers(identifiers);
            this.orderRepository.save((Object)orderDao);
            HashSet<AcmeAuthorization> authorizations = new HashSet<AcmeAuthorization>();
            HashSet<String> authorizationsResp = new HashSet<String>();
            for (AcmeIdentifier acmeIdentifier : identifiers) {
                Name name;
                AcmeAuthorization authorizationDao = new AcmeAuthorization();
                authorizationDao.setAcmeAuthorizationId(Long.valueOf(this.generateId()));
                authorizationDao.setOrder(orderDao);
                try {
                    Name tempName = Name.fromString((String)acmeIdentifier.getValue(), (Name)Name.root);
                    name = Name.fromString((String)IDN.toASCII(tempName.toString(), 2));
                }
                catch (TextParseException e) {
                    throw new IllegalArgumentException("DNS identifier value '" + acmeIdentifier.getValue() + "'", e);
                }
                authorizationDao.setType(acmeIdentifier.getType());
                authorizationDao.setValue(acmeIdentifier.getValue());
                this.authorizationRepository.save((Object)authorizationDao);
                HashSet<AcmeChallenge> challenges = new HashSet<AcmeChallenge>();
                if (name.isWild()) {
                    LOG.debug("Wildcard requested, HTTP-01 disabled!");
                } else {
                    challenges.add(this.createChallenge("http-01", acmeIdentifier.getValue(), authorizationDao));
                }
                if (this.resolverHost != null && !this.resolverHost.isEmpty()) {
                    LOG.debug("Offering DNS-01 challenge");
                    challenges.add(this.createChallenge("dns-01", acmeIdentifier.getValue(), authorizationDao));
                } else {
                    LOG.debug("DNS-01 challenge skipped, no dns resolver configured.");
                    if (name.isWild()) {
                        LOG.info("Wildcard requested, but no dns resolver configured!");
                        ProblemDetail problemDetail = new ProblemDetail(ACMEUtil.MALFORMED, "DNS auth not supported", HttpStatus.BAD_REQUEST, "DNS-01 challenge skipped, no dns resolver configured.", ACMEController.NO_INSTANCE);
                        throw new AcmeProblemException(problemDetail);
                    }
                }
                authorizationDao.setChallenges(challenges);
                this.authorizationRepository.save((Object)authorizationDao);
                authorizations.add(authorizationDao);
                authorizationsResp.add(this.locationUriOfAuth(authorizationDao.getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
            }
            orderDao.setAcmeAuthorizations(authorizations);
            this.orderRepository.save((Object)orderDao);
            String finalizeUrl = this.locationUriOfOrderFinalize(orderDao.getOrderId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString();
            NewOrderResponse newOrderResponse = new NewOrderResponse(orderDao, authorizationsResp, finalizeUrl);
            URI locationUri = this.locationUriOfOrder(orderDao.getOrderId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            additionalHeaders.set("Link", "<" + this.directoryResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize() + ">;rel=\"index\"");
            LOG.debug("returning new order response " + this.jwtUtil.getOrderResponseAsJSON(newOrderResponse));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)locationUri).headers(additionalHeaders)).body((Object)newOrderResponse);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private AcmeChallenge createChallenge(String type, String value, AcmeAuthorization authorizationDao) {
        AcmeChallenge challengeDao = new AcmeChallenge();
        challengeDao.setChallengeId(Long.valueOf(this.generateId()));
        challengeDao.setAcmeAuthorization(authorizationDao);
        challengeDao.setType(type);
        challengeDao.setValue(value);
        challengeDao.setToken(this.getRandomChallenge());
        challengeDao.setStatus(ChallengeStatus.PENDING);
        this.challengeRepository.save((Object)challengeDao);
        return challengeDao;
    }
}

