/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.dto.acme.ChallengeResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

@Controller
@RequestMapping(value={"/acme/{realm}/challenge"})
public class ChallengeController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(ChallengeController.class);
    public static final Name ACME_CHALLENGE_PREFIX = Name.fromConstantString((String)"_acme-challenge");
    @Value(value="${ca3s.acme.reject.get:true}")
    boolean rejectGet;
    private final AcmeChallengeRepository challengeRepository;
    private final AcmeOrderRepository orderRepository;
    private final PreferenceUtil preferenceUtil;
    private final SimpleResolver dnsResolver;

    public ChallengeController(AcmeChallengeRepository challengeRepository, AcmeOrderRepository orderRepository, PreferenceUtil preferenceUtil, @Value(value="${ca3s.dns.server:}") String resolverHost, @Value(value="${ca3s.dns.port:53}") int resolverPort) throws UnknownHostException {
        this.challengeRepository = challengeRepository;
        this.orderRepository = orderRepository;
        this.preferenceUtil = preferenceUtil;
        this.dnsResolver = new SimpleResolver(resolverHost);
        this.dnsResolver.setPort(resolverPort);
        LOG.info("Applying default DNS resolver {}", (Object)this.dnsResolver.getAddress());
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getChallenge(@PathVariable long challengeId) {
        LOG.debug("Received Challenge request ");
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        if (this.rejectGet) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(additionalHeaders)).build();
        }
        Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
        if (!challengeOpt.isPresent()) {
            return ResponseEntity.notFound().headers(additionalHeaders).build();
        }
        AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
        LOG.debug("returning challenge {}", (Object)challengeDao.getId());
        ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
        if (challengeDao.getStatus() == ChallengeStatus.VALID) {
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postChallenge(@RequestBody String requestBody, @PathVariable long challengeId) {
        LOG.debug("Received Challenge request ");
        try {
            ChallengeStatus oldChallengeState;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
            if (!challengeOpt.isPresent()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
            AcmeOrder order = challengeDao.getAcmeAuthorization().getOrder();
            if (!order.getAccount().getAccountId().equals(acctDao.getAccountId())) {
                LOG.warn("Account of signing key {} does not match account id {} associated to given challenge{}", new Object[]{acctDao.getAccountId(), challengeDao.getAcmeAuthorization().getOrder().getAccount().getAccountId(), challengeId});
                ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, "Account / Auth mismatch", HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            LOG.debug("checking challenge {}", (Object)challengeDao.getId());
            boolean solved = false;
            ChallengeStatus newChallengeState = null;
            if ("http-01".equals(challengeDao.getType())) {
                if (this.checkChallengeHttp(challengeDao)) {
                    newChallengeState = ChallengeStatus.VALID;
                    solved = true;
                } else {
                    newChallengeState = ChallengeStatus.INVALID;
                }
            } else if ("dns-01".equals(challengeDao.getType())) {
                if (this.checkChallengeDNS(challengeDao)) {
                    newChallengeState = ChallengeStatus.VALID;
                    solved = true;
                } else {
                    newChallengeState = ChallengeStatus.INVALID;
                }
            } else {
                LOG.warn("Unexpected type '{}' of challenge{}", (Object)challengeDao.getType(), (Object)challengeId);
            }
            if (newChallengeState != null && !(oldChallengeState = challengeDao.getStatus()).equals((Object)newChallengeState)) {
                challengeDao.setStatus(newChallengeState);
                challengeDao.setValidated(Instant.now());
                this.challengeRepository.save((Object)challengeDao);
                LOG.debug("{} challengeDao set to '{}' at {}", new Object[]{challengeDao.getType(), challengeDao.getStatus().toString(), challengeDao.getValidated()});
            }
            this.alignOrderState(order);
            ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
            if (solved) {
                URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
                additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            } else {
                LOG.warn("validation of challenge{} of type '{}' failed", (Object)challengeId, (Object)challengeDao.getType());
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    void alignOrderState(AcmeOrder orderDao) {
        if (orderDao.getStatus().equals((Object)AcmeOrderStatus.READY)) {
            LOG.info("order status already '{}', no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        if (orderDao.getStatus() != AcmeOrderStatus.PENDING) {
            LOG.warn("unexpected order status '{}' (!= Pending), no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        boolean orderReady = true;
        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
            boolean authReady = false;
            for (AcmeChallenge challDao : authDao.getChallenges()) {
                if (challDao.getStatus() != ChallengeStatus.VALID) continue;
                LOG.debug("challenge {} of type {} is valid ", (Object)challDao.getChallengeId(), (Object)challDao.getType());
                authReady = true;
                break;
            }
            if (authReady) {
                LOG.debug("found valid challenge, authorization id {} is valid ", (Object)authDao.getAcmeAuthorizationId());
                continue;
            }
            LOG.debug("no valid challange, authorization id {} and order {} fails ", (Object)authDao.getAcmeAuthorizationId(), (Object)orderDao.getOrderId());
            orderReady = false;
            break;
        }
        if (orderReady) {
            LOG.debug("order status set to READY");
            orderDao.setStatus(AcmeOrderStatus.READY);
            this.orderRepository.save((Object)orderDao);
        }
    }

    private boolean checkChallengeDNS(AcmeChallenge challengeDao) {
        Name nameToLookup;
        String identifierValue = challengeDao.getValue();
        String token = challengeDao.getToken();
        try {
            Name nameOfIdentifier = Name.fromString((String)identifierValue, (Name)Name.root);
            nameToLookup = Name.concatenate((Name)ACME_CHALLENGE_PREFIX, (Name)nameOfIdentifier);
        }
        catch (NameTooLongException | TextParseException e) {
            throw new RuntimeException(identifierValue + " invalid", e);
        }
        Lookup lookupOperation = new Lookup(nameToLookup, 16);
        lookupOperation.setResolver((Resolver)this.dnsResolver);
        lookupOperation.setCache(null);
        LOG.info("DNS lookup: {} records of '{}' (via resolver '{}')", new Object[]{Type.string((int)16), nameToLookup, this.dnsResolver.getAddress()});
        Instant startedAt = Instant.now();
        Object[] lookupResult = lookupOperation.run();
        Duration lookupDuration = Duration.between(startedAt, Instant.now());
        LOG.info("DNS lookup yields: {} (took {})", (Object)Arrays.toString(lookupResult), (Object)lookupDuration);
        List retrievedToken = this.extractTokenFrom((Record[])lookupResult);
        if (retrievedToken.isEmpty()) {
            LOG.info("Found no DNS entry solving '{}'", (Object)identifierValue);
            return false;
        }
        boolean matchingDnsEntryFound = retrievedToken.stream().anyMatch(token::equals);
        if (matchingDnsEntryFound) {
            return true;
        }
        LOG.info("Did not find matching token '{}' in TXT record DNS response", (Object)token);
        return false;
    }

    @NotNull
    private List<String> extractTokenFrom(Record[] lookupResult) {
        ArrayList<String> tokenList = new ArrayList<String>();
        if (lookupResult != null) {
            for (Record record : lookupResult) {
                LOG.debug("Found DNS entry solving '{}'", (Object)record);
                tokenList.addAll(((TXTRecord)record).getStrings());
            }
        }
        return tokenList;
    }

    private boolean checkChallengeHttp(AcmeChallenge challengeDao) {
        int[] ports = new int[]{80, 5544, 8800};
        long timeoutMilliSec = this.preferenceUtil.getAcmeHTTP01TimeoutMilliSec();
        String portList = this.preferenceUtil.getAcmeHTTP01CallbackPorts();
        if (portList != null && !portList.trim().isEmpty()) {
            String[] parts = portList.split(",");
            ports = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ports[i] = -1;
                try {
                    ports[i] = Integer.parseInt(parts[i].trim());
                    LOG.debug("checkChallengeHttp port number '" + ports[i] + "' configured for HTTP callback");
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("checkChallengeHttp port number parsing fails for '" + ports[i] + "', ignoring", (Throwable)nfe);
                }
            }
        }
        String token = challengeDao.getToken();
        String pkThumbprint = challengeDao.getAcmeAuthorization().getOrder().getAccount().getPublicKeyHash();
        String expectedContent = token + '.' + pkThumbprint;
        String fileNamePath = "/.well-known/acme-challenge/" + token;
        String host = challengeDao.getAcmeAuthorization().getValue();
        for (int port : ports) {
            try {
                URL url = new URL("http", host, port, fileNamePath);
                LOG.debug("Opening connection to  : " + url);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setConnectTimeout((int)timeoutMilliSec);
                con.setReadTimeout((int)timeoutMilliSec);
                con.setRequestMethod("GET");
                con.setRequestProperty("User-Agent", "CA3S_ACME");
                int responseCode = con.getResponseCode();
                LOG.debug("\nSending 'GET' request to URL : " + url);
                LOG.debug("Response Code : " + responseCode);
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    String actualContent = response.toString().trim();
                    LOG.debug("read challenge response: " + actualContent);
                    LOG.debug("expected content: '{}'", (Object)expectedContent);
                    return expectedContent.equals(actualContent);
                }
                LOG.info("read challenge responded with unexpected code : " + responseCode);
            }
            catch (UnknownHostException uhe) {
                LOG.debug("unable to resolve hostname ", (Throwable)uhe);
                return false;
            }
            catch (IOException ioe) {
                LOG.info("problem reading challenge response on {}:{} for {} : {}", new Object[]{host, port, challengeDao.getId(), ioe.getMessage()});
                LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
        }
        return false;
    }

    ChallengeResponse buildChallengeResponse(AcmeChallenge challengeDao) {
        return new ChallengeResponse(challengeDao, this.locationUriOfChallenge(challengeDao.getId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
    }

    private URI locationUriOfChallenge(long challengeId, UriComponentsBuilder uriBuilder) {
        return this.challengeResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path(Long.toString(challengeId)).build().normalize().toUri();
    }

    private URI locationUriOfAuthorization(long authorizationId, UriComponentsBuilder uriBuilder) {
        return this.authorizationResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path("..").path("/").path(Long.toString(authorizationId)).build().normalize().toUri();
    }
}

