/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.trustable.ca3s.core.security.KeycloakUserDetails;
import de.trustable.ca3s.core.security.OIDCRestService;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/oidc"})
public class OIDCAuthenticationResource {
    private final Logger log = LoggerFactory.getLogger(OIDCAuthenticationResource.class);
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    private final String keycloakAuthorizationUri;
    private final OIDCRestService oidcRestService;
    private KeycloakDeployment deployment;

    public OIDCAuthenticationResource(TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder, @Value(value="${ca3s.oidc.authorization-uri:}") String keycloakAuthorizationUri, @Value(value="${ca3s.oidc.client-id}") String clientId, @Value(value="${ca3s.oidc.client-secret}") String clientSecret, OIDCRestService OIDCRestService2) {
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
        this.keycloakAuthorizationUri = keycloakAuthorizationUri;
        this.oidcRestService = OIDCRestService2;
        if (keycloakAuthorizationUri.isEmpty()) {
            String authServerUrl = keycloakAuthorizationUri;
            try {
                String authUrl = StringUtils.substringBefore((String)authServerUrl, (String)"/realms/");
                String postRealms = StringUtils.substringAfter((String)authServerUrl, (String)"/realms/");
                String realm = StringUtils.substringBefore((String)postRealms, (int)47);
                this.log.info("authUrl : {}, realm : {}", (Object)authUrl, (Object)realm);
                AdapterConfig adapterConfig = new AdapterConfig();
                adapterConfig.setRealm(realm);
                adapterConfig.setAuthServerUrl(authUrl);
                adapterConfig.setResource(clientId);
                this.deployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
                this.log.info("Using oidcDeployment: {}", (Object)this.deployment);
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to parse the realm name.", cause);
            }
        }
    }

    @CrossOrigin
    @GetMapping(value={"/authenticate"})
    public ResponseEntity<String> getAuthenticatedUser(HttpServletRequest request) {
        if (this.keycloakAuthorizationUri.isEmpty()) {
            this.log.info("oidc Authentication not configured");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.getUserPrincipal() == null) {
            this.log.info("Not authenticated, forwarding");
            ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
            String redirectCodeUri = servletUriComponentsBuilder.path("/../code").build().normalize().toString();
            KeycloakUriBuilder builder = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectCodeUri}).queryParam("scope", new Object[]{"openid"}).queryParam("state", new Object[]{UUID.randomUUID().toString()});
            String redirectUrl = builder.build(new Object[0]).toString();
            this.log.info("redirectUrl : '{}'", (Object)redirectUrl);
            httpHeaders.add("Access-Control-Allow-Origin", "*");
            httpHeaders.add("Access-Control-Allow-Methods", "GET, POST, PATCH, PUT, DELETE, OPTIONS");
            httpHeaders.add("Access-Control-Allow-Headers", "Origin, Content-Type, X-Auth-Token");
            httpHeaders.add("Location", redirectUrl);
            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        this.log.info("Bearer Token created for oidc Authentication");
        return new ResponseEntity((Object)request.getRemoteUser(), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    @GetMapping(value={"/code"})
    public ResponseEntity<String> getCode(HttpServletRequest request, @RequestParam(name="code") String code) {
        if (this.keycloakAuthorizationUri.isEmpty()) {
            this.log.info("oidc Authentication not configured");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
            String redirectUri = servletUriComponentsBuilder.path("/../code").build().normalize().toString();
            String token = this.oidcRestService.exchangeCodeToToken(code, redirectUri);
            this.log.info("getCode() code : '{}', token was '{}'", (Object)code, (Object)token);
            KeycloakUserDetails keycloakUserDetails = this.oidcRestService.getUserInfo(token);
            if (keycloakUserDetails != null) {
                SecurityContext securityContext = SecurityContextHolder.getContext();
                this.log.info("Current authentication in SecurityContext: " + securityContext.getAuthentication());
                ArrayList attributes = new ArrayList();
                OpenIDAuthenticationToken authentication = new OpenIDAuthenticationToken((Object)keycloakUserDetails.getName(), (Collection)this.oidcRestService.getAuthorities(keycloakUserDetails), "identityUrl", attributes);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                securityContext.setAuthentication((Authentication)authentication);
                String jwt = this.tokenProvider.createToken((Authentication)authentication, false);
                HttpHeaders httpHeaders = new HttpHeaders();
                String startUri = servletUriComponentsBuilder.path("/../..").queryParam("bearer", new Object[]{jwt}).build().normalize().toString();
                httpHeaders.add("Location", startUri);
                httpHeaders.add("Authorization", "Bearer " + jwt);
                return new ResponseEntity((Object)keycloakUserDetails.getName(), (MultiValueMap)httpHeaders, HttpStatus.TEMPORARY_REDIRECT);
            }
            this.log.info("keycloakUserDetails == null, token was '{}'", (Object)token);
        }
        catch (RuntimeException re) {
            this.log.warn("problem processing OIDC code, token or authentication", (Throwable)re);
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            this.log.warn("problem processing OIDC code and token", e);
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }
}

