/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.service.AuditTraceService;
import de.trustable.ca3s.core.service.dto.AuditTraceView;
import io.github.jhipster.web.util.PaginationUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api"})
public class AuditTraceViewResource {
    private final Logger log = LoggerFactory.getLogger(AuditTraceViewResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AuditTraceService auditTraceService;

    public AuditTraceViewResource(AuditTraceService auditTraceService) {
        this.auditTraceService = auditTraceService;
    }

    @GetMapping(value={"/audit-trace-views"})
    public ResponseEntity<Page<AuditTraceView>> getAllAuditTraces(Pageable pageable, HttpServletRequest request, @RequestParam(value="certificateId", required=false) Long certificateId, @RequestParam(value="csrId", required=false) Long csrId, @RequestParam(value="pipelineId", required=false) Long pipelineId, @RequestParam(value="caConnectorId", required=false) Long caConnectorId, @RequestParam(value="processInfoId", required=false) Long processInfoId) {
        this.log.debug("REST request to get AuditTraceViews");
        if (certificateId == null) {
            certificateId = Long.MIN_VALUE;
        }
        if (csrId == null) {
            csrId = Long.MIN_VALUE;
        }
        if (pipelineId == null) {
            pipelineId = Long.MIN_VALUE;
        }
        if (caConnectorId == null) {
            caConnectorId = Long.MIN_VALUE;
        }
        if (processInfoId == null) {
            processInfoId = Long.MIN_VALUE;
        }
        Page page = this.auditTraceService.findBy(pageable, certificateId, csrId, pipelineId, caConnectorId, processInfoId);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        ArrayList<AuditTraceView> alvList = new ArrayList<AuditTraceView>(page.getContent().size());
        for (AuditTrace at : page.getContent()) {
            alvList.add(new AuditTraceView(at));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new PageImpl(alvList));
    }
}

