/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.AcmeOrderService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AcmeOrderResource {
    private final Logger log = LoggerFactory.getLogger(AcmeOrderResource.class);
    private static final String ENTITY_NAME = "acmeOrder";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeOrderService acmeOrderService;

    public AcmeOrderResource(AcmeOrderService acmeOrderService) {
        this.acmeOrderService = acmeOrderService;
    }

    @PostMapping(value={"/acme-orders"})
    public ResponseEntity<AcmeOrder> createAcmeOrder(@Valid @RequestBody AcmeOrder acmeOrder) throws URISyntaxException {
        this.log.debug("REST request to save AcmeOrder : {}", (Object)acmeOrder);
        if (acmeOrder.getId() != null) {
            throw new BadRequestAlertException("A new acmeOrder cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeOrder result = this.acmeOrderService.save(acmeOrder);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-orders/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-orders"})
    public ResponseEntity<AcmeOrder> updateAcmeOrder(@Valid @RequestBody AcmeOrder acmeOrder) throws URISyntaxException {
        this.log.debug("REST request to update AcmeOrder : {}", (Object)acmeOrder);
        if (acmeOrder.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeOrder result = this.acmeOrderService.save(acmeOrder);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeOrder.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-orders"})
    public List<AcmeOrder> getAllAcmeOrders() {
        this.log.debug("REST request to get all AcmeOrders");
        return this.acmeOrderService.findAll();
    }

    @GetMapping(value={"/acme-orders/{id}"})
    public ResponseEntity<AcmeOrder> getAcmeOrder(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeOrder : {}", (Object)id);
        Optional acmeOrder = this.acmeOrderService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeOrder);
    }

    @DeleteMapping(value={"/acme-orders/{id}"})
    public ResponseEntity<Void> deleteAcmeOrder(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeOrder : {}", (Object)id);
        this.acmeOrderService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

