/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.AcmeOrderService;
import de.trustable.ca3s.core.service.dto.ACMEChallengeView;
import de.trustable.ca3s.core.service.dto.ACMEOrderView;
import de.trustable.ca3s.core.service.util.ACMEOrderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@RequestMapping(value={"/api"})
public class ACMEOrderViewResource {
    private final Logger log = LoggerFactory.getLogger(ACMEOrderViewResource.class);
    private final AcmeOrderService acmeOrderService;
    private final ACMEOrderUtil acmeOrderUtil;

    public ACMEOrderViewResource(AcmeOrderService acmeOrderService, ACMEOrderUtil acmeOrderUtil) {
        this.acmeOrderService = acmeOrderService;
        this.acmeOrderUtil = acmeOrderUtil;
    }

    @GetMapping(value={"/acmeOrderViews"})
    public List<ACMEOrderView> getAllACMEOrderViews() {
        this.log.debug("REST request to get all ACMEOrderViews");
        ArrayList<ACMEOrderView> avList = new ArrayList<ACMEOrderView>();
        for (AcmeOrder acmeOrder : this.acmeOrderService.findAll()) {
            avList.add(this.acmeOrderUtil.from(acmeOrder));
        }
        return avList;
    }

    @GetMapping(value={"/acmeOrderViews/{id}"})
    public ResponseEntity<ACMEOrderView> getacmeOrder(@PathVariable Long id) {
        this.log.debug("REST request to get acmeOrderView : {}", (Object)id);
        Optional acmeOrderOptional = this.acmeOrderService.findOne(id);
        Optional<Object> avOpt = Optional.empty();
        if (acmeOrderOptional.isPresent()) {
            AcmeOrder acmeOrder = (AcmeOrder)acmeOrderOptional.get();
            ACMEOrderView acmeOrderView = this.acmeOrderUtil.from(acmeOrder);
            avOpt = Optional.of(acmeOrderView);
        } else {
            this.log.info("acme order not found, order id '{}' unknown!", (Object)id);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }

    @GetMapping(value={"/acmeOrderView/{id}/challenges"})
    public ResponseEntity<List<ACMEChallengeView>> getAcmeChallenges(@PathVariable Long id) {
        this.log.debug("REST request to get challenges of acme order : {}", (Object)id);
        Optional acmeOrderOptional = this.acmeOrderService.findOne(id);
        if (acmeOrderOptional.isPresent()) {
            AcmeOrder acmeOrder = (AcmeOrder)acmeOrderOptional.get();
            List acmeChallengeViewList = this.acmeOrderUtil.challengeListfrom(acmeOrder);
            HttpHeaders additionalHeaders = new HttpHeaders();
            additionalHeaders.add("X-Total-Count", Long.toString(acmeChallengeViewList.size()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)acmeChallengeViewList);
        }
        this.log.info("challenges of acme order not found, order id '{}' unknown!", (Object)id);
        return ResponseEntity.notFound().build();
    }
}

