/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.BPMNProcessType;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ConfigUtil;
import de.trustable.ca3s.core.service.util.NameAndRoleUtil;
import de.trustable.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bouncycastle.asn1.x509.CRLReason;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BPMNUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNUtil.class);
    public static final String CAINVOCATION_PROCESS = "CAInvocationProcess";
    private final ConfigUtil configUtil;
    private final CaConnectorAdapter caConnAdapter;
    private final CAConnectorConfigRepository caConnConRepo;
    private final CryptoUtil cryptoUtil;
    private final RuntimeService runtimeService;
    private final RepositoryService repoService;
    private final BPMNProcessInfoRepository bpnmInfoRepo;
    private final CSRRepository csrRepository;
    private final CertificateRepository certRepository;
    private final CertificateUtil certUtil;
    private final NameAndRoleUtil nameAndRoleUtil;

    @Autowired
    public BPMNUtil(ConfigUtil configUtil, CaConnectorAdapter caConnAdapter, CAConnectorConfigRepository caConnConRepo, CryptoUtil cryptoUtil, RuntimeService runtimeService, RepositoryService repoService, BPMNProcessInfoRepository bpnmInfoRepo, CSRRepository csrRepository, CertificateRepository certRepository, CertificateUtil certUtil, NameAndRoleUtil nameAndRoleUtil) {
        this.configUtil = configUtil;
        this.caConnAdapter = caConnAdapter;
        this.caConnConRepo = caConnConRepo;
        this.cryptoUtil = cryptoUtil;
        this.runtimeService = runtimeService;
        this.repoService = repoService;
        this.bpnmInfoRepo = bpnmInfoRepo;
        this.csrRepository = csrRepository;
        this.certRepository = certRepository;
        this.certUtil = certUtil;
        this.nameAndRoleUtil = nameAndRoleUtil;
    }

    public String addModel(String bpmnString, String name) {
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(bpmnString.getBytes(StandardCharsets.UTF_8)));
        String modelName = name + ".bpmn20.xml";
        Deployment deployment = this.repoService.createDeployment().addModelInstance(modelName, modelInstance).deploy();
        LOG.debug("deployment with name {} and if {} is a {}", new Object[]{modelName, deployment.getId(), deployment.getClass().getName()});
        for (ProcessDefinition pd : this.getProcessDefinitions()) {
            LOG.debug("process definition with name {}, id {}, versionTag {}, deploymentId {}, key {} found", new Object[]{pd.getName(), pd.getId(), pd.getVersionTag(), pd.getDeploymentId(), pd.getKey()});
        }
        ProcessDefinition pdNew = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list().get(0);
        LOG.debug("New process definition Id '{}'", (Object)pdNew.getId());
        return pdNew.getId();
    }

    public List<ProcessDefinition> getProcessDefinitions() {
        return this.repoService.createProcessDefinitionQuery().latestVersion().list();
    }

    public InputStream getProcessContent(String processId) {
        return this.repoService.getProcessModel(processId);
    }

    public void updateProcessDefinitions() {
        List pdList = this.getProcessDefinitions();
        for (ProcessDefinition pd : pdList) {
            Optional optBI = this.bpnmInfoRepo.findByName(pd.getKey());
            if (!optBI.isPresent()) {
                this.buildBPMNProcessInfoByProcess(pd, pd.getKey(), BPMNProcessType.CA_INVOCATION);
                continue;
            }
            LOG.debug("BPNMProcessInfo {} already exists", (Object)pd.getKey());
        }
    }

    public BPMNProcessInfo buildBPMNProcessInfoByProcessId(String processId, String name, BPMNProcessType bpmnProcessType) {
        List pdList = this.repoService.createProcessDefinitionQuery().processDefinitionId(processId).list();
        if (pdList.isEmpty()) {
            LOG.debug("retrieving ProcessDefinition for id '{}' failed ...", (Object)processId);
        }
        return this.buildBPMNProcessInfoByProcess((ProcessDefinition)pdList.get(0), name, bpmnProcessType);
    }

    public BPMNProcessInfo buildBPMNProcessInfoByProcess(ProcessDefinition pd, String name, BPMNProcessType bpmnProcessType) {
        BPMNProcessInfo newBI = new BPMNProcessInfo();
        newBI.setAuthor(this.nameAndRoleUtil.getNameAndRole().getName());
        newBI.setLastChange(Instant.now());
        newBI.setName(name);
        String version = pd.getVersionTag();
        if (version == null) {
            version = "0.0.1";
        }
        newBI.setVersion(version);
        newBI.setType(bpmnProcessType);
        newBI.setSignatureBase64("1234");
        newBI.setBpmnHashBase64("bpmnHash");
        newBI.setProcessId(pd.getId());
        LOG.info("added new BPNMProcessInfo from camunda database: {}", (Object)newBI);
        this.bpnmInfoRepo.save((Object)newBI);
        return newBI;
    }

    public void deleteProcessDefinitions(String processId) {
        this.repoService.deleteProcessDefinitions().byIds(new String[]{processId}).delete();
    }

    public Certificate startCertificateCreationProcess(CSR csr) {
        CAConnectorConfig caConfig;
        BPMNProcessInfo pi = null;
        if (csr.getPipeline() == null) {
            LOG.warn("No pipeline information in CSR #{}", (Object)csr.getId());
            caConfig = this.configUtil.getDefaultConfig();
        } else {
            caConfig = csr.getPipeline().getCaConnector();
            pi = csr.getPipeline().getProcessInfo();
        }
        return this.startCertificateCreationProcess(csr, caConfig, pi);
    }

    public Certificate startCertificateCreationProcess(CSR csr, CAConnectorConfig caConfig, BPMNProcessInfo processInfo) {
        String processName;
        String status = "Failed";
        String certificateId = "";
        Certificate certificate = null;
        String failureReason = "";
        String processInstanceId = "";
        if (processInfo != null) {
            processName = processInfo.getName();
        } else {
            List processDefinitionList = this.repoService.createProcessDefinitionQuery().processDefinitionKey(CAINVOCATION_PROCESS).latestVersion().list();
            if (processDefinitionList.isEmpty()) {
                LOG.warn("Default process 'CAInvocationProcess' not found!");
                return null;
            }
            processName = ((ProcessDefinition)processDefinitionList.get(0)).getId();
        }
        if (caConfig != null) {
            if (processName != null && processName.trim().length() > 0) {
                try {
                    Map variables = this.buildVariableMapFromCSR(csr, caConfig);
                    variables.put("certificateId", certificateId);
                    ProcessInstanceWithVariables processInstance = this.executeBPMNProcessByName(processName, variables);
                    certificate = (Certificate)processInstance.getVariables().get((Object)"certificate");
                    status = processInstance.getVariables().get((Object)"status").toString();
                    if (processInstance.getVariables().get((Object)"failureReason") != null) {
                        failureReason = processInstance.getVariables().get((Object)"failureReason").toString();
                    }
                }
                catch (Exception e) {
                    failureReason = e.getLocalizedMessage();
                    LOG.warn("execution of '" + processName + "' failed ", (Throwable)e);
                }
            } else {
                try {
                    certificate = this.caConnAdapter.signCertificateRequest(csr, caConfig);
                    status = "Created";
                }
                catch (GeneralSecurityException e) {
                    failureReason = e.getLocalizedMessage();
                    LOG.error(failureReason);
                }
            }
        } else {
            failureReason = "no default and active CA configured";
            LOG.error(failureReason);
        }
        if ("Created".equals(status)) {
            if (certificate != null) {
                certificate.setCsr(csr);
                this.certUtil.setCertAttribute(certificate, "CA_CONNECTOR_ID", caConfig.getId().longValue());
                this.certRepository.save((Object)certificate);
                csr.setCertificate(certificate);
                csr.setStatus(CsrStatus.ISSUED);
                this.csrRepository.save((Object)csr);
                LOG.debug("new certificate id {} created by BPMN process {}", (Object)certificate.getId(), (Object)processInstanceId);
                return certificate;
            }
            LOG.warn("creation of certificate by BPMN process {} failed, no certificate returned ", (Object)processInstanceId);
        } else {
            LOG.warn("creation of certificate by BPMN process {} failed with reason '{}' ", (Object)processInstanceId, (Object)failureReason);
        }
        return null;
    }

    public ProcessInstanceWithVariables checkCertificateCreationProcess(CSR csr, CAConnectorConfig caConfig, String processName) {
        Map variables = this.buildVariableMapFromCSR(csr, caConfig);
        return this.executeBPMNProcessByName(processName, variables);
    }

    @NotNull
    private Map<String, Object> buildVariableMapFromCSR(CSR csr, CAConnectorConfig caConfig) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("csrId", csr.getId());
        variables.put("csr", csr);
        variables.put("csrAttributes", csr.getCsrAttributes());
        variables.put("caConfigId", caConfig.getId());
        return variables;
    }

    private ProcessInstanceWithVariables executeBPMNProcessByName(String processNameId, Map<String, Object> variables) {
        LOG.debug("execute BPMN Process with id {} ", (Object)processNameId);
        variables.put("status", "Failed");
        variables.put("failureReason", "");
        try {
            ProcessInstanceWithVariables processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processNameId).setVariables(variables)).executeWithVariablesInReturn();
            String processInstanceId = processInstance.getId();
            LOG.info("ProcessInstance: {}", (Object)processInstanceId);
            return processInstance;
        }
        catch (RuntimeException processException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception while calling bpmn process '" + processNameId + "'", (Throwable)processException);
            }
            throw processException;
        }
    }

    public void startCertificateRevoctionProcess(Certificate certificate, CRLReason crlReason, Date revocationDate) throws GeneralSecurityException {
        String processInstanceId;
        String failureReason;
        String status;
        block15: {
            CAConnectorConfig caConfigDefault;
            status = "Failed";
            failureReason = "";
            processInstanceId = "";
            String processName = CAINVOCATION_PROCESS;
            if (certificate == null) {
                throw new GeneralSecurityException("certificate to be revoked MUST be provided");
            }
            if (crlReason == null) {
                throw new GeneralSecurityException("revocation reason for certificate " + certificate.getId() + " MUST be provided");
            }
            if (revocationDate == null) {
                throw new GeneralSecurityException("revocation date for certificate " + certificate.getId() + " MUST be provided");
            }
            String caConnectorId = this.certUtil.getCertAttribute(certificate, "CA_CONNECTOR_ID");
            if (caConnectorId == null && (caConfigDefault = this.configUtil.getDefaultConfig()) != null) {
                caConnectorId = caConfigDefault.getId().toString();
            }
            if (caConnectorId != null) {
                LOG.debug("revoke certificate '{}' at CA with config '{}' ", (Object)certificate.getId(), (Object)caConnectorId);
                if (processName.trim().length() > 0) {
                    try {
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        variables.put("action", "Revoke");
                        variables.put("caConfigId", caConnectorId);
                        variables.put("status", "Failed");
                        variables.put("certificateId", certificate.getId());
                        variables.put("certificate", certificate);
                        variables.put("revocationReason", this.cryptoUtil.crlReasonAsString(crlReason));
                        variables.put("revocationDate", revocationDate.getTime());
                        variables.put("failureReason", failureReason);
                        ProcessInstanceWithVariables processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(processName).setVariables(variables)).executeWithVariablesInReturn();
                        processInstanceId = processInstance.getId();
                        LOG.info("ProcessInstance: {}", (Object)processInstanceId);
                        status = processInstance.getVariables().get((Object)"status").toString();
                        if (processInstance.getVariables().get((Object)"failureReason") != null) {
                            failureReason = processInstance.getVariables().get((Object)"failureReason").toString();
                        }
                    }
                    catch (Exception e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.warn("execution of '" + processName + "' failed ", (Throwable)e);
                    }
                } else {
                    try {
                        Optional caConfigOpt = this.caConnConRepo.findById((Object)Long.parseLong(caConnectorId));
                        if (caConfigOpt.isPresent()) {
                            this.caConnAdapter.revokeCertificate(certificate, crlReason, revocationDate, (CAConnectorConfig)caConfigOpt.get());
                            status = "Revoked";
                            break block15;
                        }
                        failureReason = "caConnectorId '" + caConnectorId + "' is unknown";
                        LOG.error(failureReason);
                    }
                    catch (GeneralSecurityException e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.error(failureReason);
                    }
                }
            } else {
                failureReason = "no default and active CA configured";
                LOG.error(failureReason);
            }
        }
        if (!"Revoked".equals(status)) {
            LOG.warn("revocation of certificate by BPMN process {} failed with reason '{}' ", (Object)processInstanceId, (Object)failureReason);
            throw new GeneralSecurityException(failureReason);
        }
        LOG.debug("certificate id {} revoked by BPMN process {}", (Object)certificate.getId(), (Object)processInstanceId);
    }
}

