/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.repository.RequestProxyConfigRepository;
import de.trustable.ca3s.core.service.RequestProxyConfigService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RequestProxyConfigServiceImpl
implements RequestProxyConfigService {
    private final Logger log = LoggerFactory.getLogger(RequestProxyConfigServiceImpl.class);
    private final RequestProxyConfigRepository requestProxyConfigRepository;

    public RequestProxyConfigServiceImpl(RequestProxyConfigRepository requestProxyConfigRepository) {
        this.requestProxyConfigRepository = requestProxyConfigRepository;
    }

    public RequestProxyConfig save(RequestProxyConfig requestProxyConfig) {
        this.log.debug("Request to save RequestProxyConfig : {}", (Object)requestProxyConfig);
        return (RequestProxyConfig)this.requestProxyConfigRepository.save((Object)requestProxyConfig);
    }

    @Transactional(readOnly=true)
    public List<RequestProxyConfig> findAll() {
        this.log.debug("Request to get all RequestProxyConfigs");
        return this.requestProxyConfigRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<RequestProxyConfig> findOne(Long id) {
        this.log.debug("Request to get RequestProxyConfig : {}", (Object)id);
        return this.requestProxyConfigRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete RequestProxyConfig : {}", (Object)id);
        this.requestProxyConfigRepository.deleteById((Object)id);
    }
}

