/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.RequestAttribute;
import de.trustable.ca3s.core.repository.RequestAttributeRepository;
import de.trustable.ca3s.core.service.RequestAttributeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RequestAttributeServiceImpl
implements RequestAttributeService {
    private final Logger log = LoggerFactory.getLogger(RequestAttributeServiceImpl.class);
    private final RequestAttributeRepository requestAttributeRepository;

    public RequestAttributeServiceImpl(RequestAttributeRepository requestAttributeRepository) {
        this.requestAttributeRepository = requestAttributeRepository;
    }

    public RequestAttribute save(RequestAttribute requestAttribute) {
        this.log.debug("Request to save RequestAttribute : {}", (Object)requestAttribute);
        return (RequestAttribute)this.requestAttributeRepository.save((Object)requestAttribute);
    }

    @Transactional(readOnly=true)
    public List<RequestAttribute> findAll() {
        this.log.debug("Request to get all RequestAttributes");
        return this.requestAttributeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<RequestAttribute> findOne(Long id) {
        this.log.debug("Request to get RequestAttribute : {}", (Object)id);
        return this.requestAttributeRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete RequestAttribute : {}", (Object)id);
        this.requestAttributeRepository.deleteById((Object)id);
    }
}

