/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.CertificateService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertificateServiceImpl
implements CertificateService {
    private final Logger log = LoggerFactory.getLogger(CertificateServiceImpl.class);
    private final CertificateRepository certificateRepository;

    public CertificateServiceImpl(CertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public Certificate save(Certificate certificate) {
        this.log.debug("Request to save Certificate : {}", (Object)certificate);
        return (Certificate)this.certificateRepository.save((Object)certificate);
    }

    @Transactional(readOnly=true)
    public Page<Certificate> findAll(Pageable pageable) {
        this.log.debug("Request to get all Certificates");
        return this.certificateRepository.findAll(pageable);
    }

    @Transactional(readOnly=true)
    public Optional<Certificate> findOne(Long id) {
        this.log.debug("Request to get Certificate : {}", (Object)id);
        return this.certificateRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Certificate : {}", (Object)id);
        this.certificateRepository.deleteById((Object)id);
    }
}

