/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.service.CSRService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CSRServiceImpl
implements CSRService {
    private final Logger log = LoggerFactory.getLogger(CSRServiceImpl.class);
    private final CSRRepository cSRRepository;

    public CSRServiceImpl(CSRRepository cSRRepository) {
        this.cSRRepository = cSRRepository;
    }

    public CSR save(CSR cSR) {
        this.log.debug("Request to save CSR : {}", (Object)cSR);
        return (CSR)this.cSRRepository.save((Object)cSR);
    }

    @Transactional(readOnly=true)
    public List<CSR> findAll() {
        this.log.debug("Request to get all CSRS");
        return this.cSRRepository.findAll();
    }

    @Transactional(readOnly=true)
    public List<CSR> findAllWhereCertificateIsNull() {
        this.log.debug("Request to get all cSRS where Certificate is null");
        return StreamSupport.stream(this.cSRRepository.findAll().spliterator(), false).filter(cSR -> cSR.getCertificate() == null).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<CSR> findOne(Long id) {
        this.log.debug("Request to get CSR : {}", (Object)id);
        return this.cSRRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete CSR : {}", (Object)id);
        this.cSRRepository.deleteById((Object)id);
    }
}

