/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.User;
import io.github.jhipster.config.JHipsterProperties;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class MailService {
    private final Logger log = LoggerFactory.getLogger(MailService.class);
    private static final String USER = "user";
    private static final String BASE_URL = "baseUrl";
    private final JHipsterProperties jHipsterProperties;
    private final JavaMailSender javaMailSender;
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;

    public MailService(JHipsterProperties jHipsterProperties, JavaMailSender javaMailSender, MessageSource messageSource, SpringTemplateEngine templateEngine) {
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
    }

    @Transactional
    public void sendEmail(String to, String subject, String content, boolean isMultipart, boolean isHtml) throws MessagingException {
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", new Object[]{isMultipart, isHtml, to, subject, content});
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
        message.setTo(to);
        message.setFrom(this.jHipsterProperties.getMail().getFrom());
        message.setSubject(subject);
        message.setText(content, isHtml);
        this.javaMailSender.send(mimeMessage);
        this.log.debug("Sent email to User '{}'", (Object)to);
    }

    @Transactional
    public void sendEmailFromTemplate(Context context, User user, String templateName, String titleKey) throws MessagingException {
        this.sendEmailFromTemplate(context, user, templateName, titleKey, null);
    }

    @Transactional
    public void sendEmailFromTemplate(Context context, User user, String templateName, String titleKey, String[] args) throws MessagingException {
        if (user.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)user.getLogin());
            return;
        }
        Locale locale = Locale.forLanguageTag(user.getLangKey());
        context.setVariable(USER, (Object)user);
        context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        String content = this.templateEngine.process(templateName, (IContext)context);
        String subject = this.messageSource.getMessage(titleKey, (Object[])args, locale);
        this.sendEmail(user.getEmail(), subject, content, false, true);
    }

    @Transactional
    public void sendEmailFromTemplate(User user, String templateName, String titleKey) throws MessagingException {
        if (user.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)user.getLogin());
            return;
        }
        Locale locale = Locale.forLanguageTag(user.getLangKey());
        Context context = new Context(locale);
        context.setVariable(USER, (Object)user);
        context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        String content = this.templateEngine.process(templateName, (IContext)context);
        String subject = this.messageSource.getMessage(titleKey, null, locale);
        this.sendEmail(user.getEmail(), subject, content, false, true);
    }

    public void sendActivationEmail(User user) throws MessagingException {
        this.log.debug("Sending activation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/activationEmail", "email.activation.title");
    }

    public void sendCreationEmail(User user) throws MessagingException {
        this.log.debug("Sending creation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/creationEmail", "email.activation.title");
    }

    public void sendPasswordResetMail(User user) throws MessagingException {
        this.log.debug("Sending password reset email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/passwordResetEmail", "email.reset.title");
    }
}

