/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.UserNotActivatedException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="userDetailsService")
public class DomainUserDetailsService
implements UserDetailsService {
    private final Logger log = LoggerFactory.getLogger(DomainUserDetailsService.class);
    private final UserRepository userRepository;

    public DomainUserDetailsService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Transactional
    public UserDetails loadUserByUsername(String login) {
        this.log.warn("----------- Authenticating {}", (Object)login);
        if (login.startsWith("Kerberos@@")) {
            String username = login.substring(10);
            return new org.springframework.security.core.userdetails.User(username, "KerberosToken", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        }
        if (new EmailValidator().isValid((CharSequence)login, null)) {
            return (UserDetails)this.userRepository.findOneWithAuthoritiesByEmailIgnoreCase(login).map(user -> this.createSpringSecurityUser(login, user)).orElseThrow(() -> new UsernameNotFoundException("User with email " + login + " was not found in the database"));
        }
        String lowercaseLogin = login.toLowerCase(Locale.ENGLISH);
        return (UserDetails)this.userRepository.findOneWithAuthoritiesByLogin(lowercaseLogin).map(user -> this.createSpringSecurityUser(lowercaseLogin, user)).orElseThrow(() -> new UsernameNotFoundException("User " + lowercaseLogin + " was not found in the database"));
    }

    private org.springframework.security.core.userdetails.User createSpringSecurityUser(String lowercaseLogin, User user) {
        if (!user.getActivated()) {
            throw new UserNotActivatedException("User " + lowercaseLogin + " was not activated");
        }
        List grantedAuthorities = user.getAuthorities().stream().map(authority -> new SimpleGrantedAuthority(authority.getName())).collect(Collectors.toList());
        return new org.springframework.security.core.userdetails.User(user.getLogin(), user.getPassword(), grantedAuthorities);
    }
}

