/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule.spider;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerWorker {
    Logger LOGGER = LoggerFactory.getLogger(CrawlerWorker.class);
    private static final String USER_AGENT = "ca3s certificate crawler";
    private List<String> links = new LinkedList();

    public boolean crawl(String url, Pattern searchPattern, Set<String> certificateSet) {
        try {
            Connection connection = Jsoup.connect((String)url).userAgent(USER_AGENT);
            Document htmlDocument = connection.get();
            if (connection.response().statusCode() >= 300) {
                this.LOGGER.debug("problem ({}) reading page at {}", (Object)connection.response().statusCode(), (Object)url);
                return false;
            }
            if (!connection.response().contentType().contains("text/html")) {
                this.LOGGER.debug("unexpected content type  '{}' found at {}", (Object)connection.response().contentType(), (Object)url);
                return false;
            }
            Elements linksOnPage = htmlDocument.select("a[href]");
            this.LOGGER.debug("found #{} links at {}", (Object)linksOnPage.size(), (Object)url);
            for (Element link : linksOnPage) {
                String href = link.absUrl("href");
                if (searchPattern.matcher(href).matches()) {
                    this.LOGGER.info("found certificate at {}", (Object)href);
                    certificateSet.add(href);
                    continue;
                }
                this.links.add(link.absUrl("href"));
            }
            return true;
        }
        catch (IOException ioe) {
            this.LOGGER.debug("problem  '{}' occurred reading {}", (Object)ioe.getMessage(), (Object)url);
            return false;
        }
    }

    public List<String> getLinks() {
        return this.links;
    }
}

