/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class SchemaUpdateScheduler {
    transient Logger LOG = LoggerFactory.getLogger(SchemaUpdateScheduler.class);
    static final int MAX_RECORDS_PER_TRANSACTION = 10000;
    @Autowired
    private CertificateRepository certificateRepo;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private AuditService auditService;

    @Scheduled(fixedDelay=60000L)
    public void updateCertificateAttributes() {
        Instant now = Instant.now();
        List updateCertificateList = this.certificateRepo.findByAttributeValueLowerThan("ATTRIBUTES_VERSION", "4");
        int count = 0;
        for (Certificate cert : updateCertificateList) {
            try {
                int currentVersion = Integer.parseInt(this.certUtil.getCertAttribute(cert, "ATTRIBUTES_VERSION"));
                X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)cert.getContent());
                if (currentVersion < 4) {
                    this.certUtil.interpretBasicConstraint(x509Cert, cert);
                }
                this.certUtil.addAdditionalCertificateAttributes(x509Cert, cert);
                this.certificateRepo.save((Object)cert);
                this.LOG.info("attribute schema updated for certificate id {} ", (Object)cert.getId());
            }
            catch (IOException | GeneralSecurityException e) {
                this.LOG.error("problem with attribute schema update for certificate id " + cert.getId(), (Throwable)e);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 4));
        }
    }
}

