/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.ACMEAccount_;
import de.trustable.ca3s.core.domain.AcmeContact;
import de.trustable.ca3s.core.domain.AcmeContact_;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.repository.AcmeContactRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.ACMEAccountView;
import de.trustable.ca3s.core.service.dto.Selector;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ACMEAccountSpecifications {
    static Logger logger = LoggerFactory.getLogger(ACMEAccountSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";

    private ACMEAccountSpecifications() {
    }

    public static Page<ACMEAccountView> handleQueryParamsACMEAccountView(EntityManager entityManager, AcmeOrderRepository acmeOrderRepository, AcmeContactRepository acmeContactRepository, CriteriaBuilder cb, Map<String, String[]> parameterMap, List<String> additionalSelectionAttributes) {
        String[] paramArr;
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(ACMEAccount.class);
        String sortCol = SpecificationsHelper.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = SpecificationsHelper.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = SpecificationsHelper.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = SpecificationsHelper.getIntValue((String[])parameterMap.get("limit"), (int)20);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = ACMEAccountSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = new String[]{};
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(ACMEAccountSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList, additionalSelectionAttributes));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(ACMEAccountSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList, additionalSelectionAttributes));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        List listResponse = typedQuery.getResultList();
        ArrayList<ACMEAccountView> acmeAccountViewList = new ArrayList<ACMEAccountView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            ACMEAccountView acmeAccountView = ACMEAccountSpecifications.buildCSRViewFromObjArr(colList, (Object[])objArr, (AcmeOrderRepository)acmeOrderRepository, (AcmeContactRepository)acmeContactRepository);
            acmeAccountViewList.add(acmeAccountView);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(ACMEAccount.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        ArrayList selectionListCount = new ArrayList();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predCountList.add(ACMEAccountSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount, additionalSelectionAttributes));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)col);
            predCountList.add(ACMEAccountSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, null, (String)"", selectionListCount, additionalSelectionAttributes));
        }
        Predicate predCount = null;
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        Long nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("buildPredicate selects {} elements ", (Object)nTotalElements);
        return new PageImpl(acmeAccountViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static ACMEAccountView buildCSRViewFromObjArr(ArrayList<String> colList, Object[] objArr, AcmeOrderRepository acmeOrderRepository, AcmeContactRepository acmeContactRepository) {
        ACMEAccountView acmeAccountView = new ACMEAccountView();
        int i = 0;
        for (String attribute : colList) {
            if (i >= objArr.length) {
                logger.debug("attribute '{}' exceeds objArr with #{} elements ", (Object)attribute, (Object)objArr.length);
                continue;
            }
            logger.debug("attribute '{}' has value '{}'", (Object)attribute, objArr[i]);
            if ("id".equalsIgnoreCase(attribute)) {
                acmeAccountView.setId((Long)objArr[i]);
            } else if ("accountId".equalsIgnoreCase(attribute)) {
                acmeAccountView.setAccountId((Long)objArr[i]);
            } else if ("status".equalsIgnoreCase(attribute)) {
                acmeAccountView.setStatus((AccountStatus)objArr[i]);
            } else if ("realm".equalsIgnoreCase(attribute)) {
                acmeAccountView.setRealm((String)objArr[i]);
            } else if ("createdOn".equalsIgnoreCase(attribute)) {
                acmeAccountView.setCreatedOn((Instant)objArr[i]);
            } else if ("publicKeyHash".equalsIgnoreCase(attribute)) {
                acmeAccountView.setPublicKeyHash((String)objArr[i]);
            } else if ("termsOfServiceAgreed".equalsIgnoreCase(attribute)) {
                acmeAccountView.setTermsOfServiceAgreed((Boolean)objArr[i]);
            } else if ("contactUrls".equalsIgnoreCase(attribute)) {
                List acmeContactList = acmeContactRepository.findByAccountId((Long)objArr[i]);
                logger.debug("acme account #\u00edd {} has #{} contacts", objArr[i], (Object)acmeContactList.size());
                ArrayList<String> contactList = new ArrayList<String>();
                for (AcmeContact acmeContact : acmeContactList) {
                    contactList.add(acmeContact.getContactUrl());
                }
                acmeAccountView.setContactUrls(contactList.toArray(new String[0]));
            } else if ("orderCount".equalsIgnoreCase(attribute)) {
                long orderCount = acmeOrderRepository.countByAccountId(((Long)objArr[i]).longValue());
                logger.debug("acme account #\u00edd {} has #{} orders", objArr[i], (Object)orderCount);
                acmeAccountView.setOrderCount(Long.valueOf(orderCount));
            } else {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return acmeAccountView;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<ACMEAccount> root, CriteriaBuilder cb, CriteriaQuery<?> csrQuery, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList, List<String> acmeAccountSelectionAttributes) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.id));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ACMEAccount_.id), (String)attributeValue);
            }
        } else if ("accountId".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.accountId));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ACMEAccount_.accountId), (String)attributeValue);
            }
        } else if ("status".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.status));
            if (attributeValue.trim().length() > 0) {
                pred = ACMEAccountSpecifications.buildPredicateAccountStatus((String)attributeSelector, (CriteriaBuilder)cb, (Path)root.get(ACMEAccount_.status), (String)attributeValue);
            }
        } else if ("realm".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.realm));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ACMEAccount_.realm), (String)attributeValue);
            }
        } else if ("termsOfServiceAgreed".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.termsOfServiceAgreed));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ACMEAccount_.termsOfServiceAgreed), (String)attributeValue);
            }
        } else if ("createdOn".equals(attribute)) {
            logger.debug("ToDo createdOn selection");
        } else if ("publicKeyHash".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ACMEAccount_.publicKeyHash));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ACMEAccount_.publicKeyHash), (String)attributeValue);
            }
        } else if ("contactUrls".equals(attribute)) {
            selectionList.add((Selection<?>)root.get(ACMEAccount_.accountId));
            if (attributeValue.trim().length() > 0) {
                SetJoin contactJoin = root.join(ACMEAccount_.contacts, JoinType.LEFT);
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)contactJoin.get(AcmeContact_.contactUrl), (String)attributeValue.toLowerCase());
            }
        } else if ("orderCount".equals(attribute)) {
            selectionList.add((Selection<?>)root.get(ACMEAccount_.accountId));
        } else {
            logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
        }
        return pred;
    }

    private static Predicate buildPredicateAccountStatus(String attributeSelector, CriteriaBuilder cb, Path<AccountStatus> path, String attributeValue) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        AccountStatus accountStatus = AccountStatus.valueOf((String)attributeValue);
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus equal ('{}') for value '{}'", (Object)attributeSelector, (Object)accountStatus);
            return cb.equal(path, (Object)accountStatus);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus notEqual ('{}') for value '{}'", (Object)attributeSelector, (Object)accountStatus);
            return cb.notEqual(path, (Object)accountStatus);
        }
        logger.debug("buildPredicateAccountStatus defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)accountStatus);
        return cb.equal(path, (Object)accountStatus);
    }
}

