/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;
import org.springframework.security.kerberos.client.config.SunJaasKrb5LoginConfig;
import org.springframework.security.kerberos.web.authentication.SpnegoAuthenticationProcessingFilter;
import org.springframework.security.kerberos.web.authentication.SpnegoEntryPoint;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

public class KerberosSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(KerberosSecurityConfiguration.class);
    @Value(value="${ca3s.auth.kerberos.keytab-location:}")
    private String keytabLocation;
    @Value(value="${ca3s.auth.kerberos.service-principal:HTTP/admin@ca3s}")
    private String servicePrincipal;
    @Value(value="${ca3s.auth.ad-domain:}")
    private String adDomain;
    @Value(value="${ca3s.auth.ldap.url:}")
    private String ldapURL;
    @Value(value="${ca3s.auth.ldap.search-base:}")
    private String ldapSearchBase;
    @Value(value="${ca3s.auth.ldap.search-filter:(| (userPrincipalName={0}) (sAMAccountName={0}))}")
    private String ldapSearchFilter;
    @Value(value="${ca3s.auth.ldap.group-search-base:}")
    private String ldapGroupSearchBase;
    @Value(value="${ca3s.auth.ldap.baseDN:}")
    private String ldapBaseDN;
    @Value(value="${ca3s.auth.ldap.principal:}")
    private String ldapPrincipal;
    @Value(value="${ca3s.auth.ldap.password:}")
    private String ldapPassword;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;

    public KerberosSecurityConfiguration(CorsFilter corsFilter, SecurityProblemSupport problemSupport) {
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (StringUtil.isBlank((String)this.keytabLocation) || StringUtil.isBlank((String)this.servicePrincipal)) {
            this.LOG.info("no values provided for 'ca3s.auth.kerberos.keytab-location' or 'ca3s.auth.kerberos.service-principal', AuthenticationManagerBuilder will not be configured for kerberos");
        } else {
            auth.authenticationProvider((AuthenticationProvider)this.kerberosServiceAuthenticationProvider());
        }
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/images/*.{jpg,png}"})).antMatchers(new String[]{"/css/*.css"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        this.LOG.info("configure HttpSecurity ");
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.spnegoEntryPoint()).and()).antMatcher("/kerberos/authenticatedUser").authorizeRequests().anyRequest()).authenticated().and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:; connect-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).csrf().disable()).addFilterBefore((Filter)this.spnegoAuthenticationProcessingFilter(), UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    public SpnegoAuthenticationProcessingFilter spnegoAuthenticationProcessingFilter() throws Exception {
        this.LOG.info("in spnegoAuthenticationProcessingFilter");
        SpnegoAuthenticationProcessingFilter filter = new SpnegoAuthenticationProcessingFilter();
        filter.setAuthenticationManager(super.authenticationManagerBean());
        return filter;
    }

    @Bean
    public KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider() throws Exception {
        this.LOG.info("in kerberosServiceAuthenticationProvider");
        KerberosServiceAuthenticationProvider provider = new KerberosServiceAuthenticationProvider();
        provider.setTicketValidator((KerberosTicketValidator)this.sunJaasKerberosTicketValidator());
        provider.setUserDetailsService(this.getUserDetailsService());
        return provider;
    }

    @Bean
    public KerberosAuthenticationProvider kerberosAuthenticationProvider() throws Exception {
        this.LOG.info("in kerberosAuthenticationProvider");
        KerberosAuthenticationProvider provider = new KerberosAuthenticationProvider();
        SunJaasKerberosClient client = new SunJaasKerberosClient();
        client.setDebug(this.LOG.isDebugEnabled());
        provider.setKerberosClient((KerberosClient)client);
        provider.setUserDetailsService(this.getUserDetailsService());
        return provider;
    }

    @Bean
    public SunJaasKerberosTicketValidator sunJaasKerberosTicketValidator() throws Exception {
        this.LOG.info("in sunJaasKerberosTicketValidator with servicePrincipal '{}' and keytabLocation '{}'", (Object)this.servicePrincipal, (Object)this.keytabLocation);
        SunJaasKerberosTicketValidator ticketValidator = new SunJaasKerberosTicketValidator();
        ticketValidator.setServicePrincipal(this.servicePrincipal);
        ticketValidator.setKeyTabLocation((Resource)new FileSystemResource(this.keytabLocation));
        ticketValidator.setDebug(this.LOG.isDebugEnabled());
        ticketValidator.afterPropertiesSet();
        return ticketValidator;
    }

    public SunJaasKrb5LoginConfig loginConfig() throws Exception {
        SunJaasKrb5LoginConfig loginConfig = new SunJaasKrb5LoginConfig();
        loginConfig.setKeyTabLocation((Resource)new FileSystemResource(this.keytabLocation));
        loginConfig.setServicePrincipal(this.servicePrincipal);
        loginConfig.setDebug(Boolean.valueOf(this.LOG.isDebugEnabled()));
        loginConfig.setIsInitiator(Boolean.valueOf(true));
        loginConfig.afterPropertiesSet();
        return loginConfig;
    }

    @Bean
    public SpnegoEntryPoint spnegoEntryPoint() {
        this.LOG.debug("in spnegoEntryPoint: forwarding to 'Add header WWW-Authenticate:Negotiate'");
        return new SpnegoEntryPoint();
    }

    @Bean
    public LdapContextSource ldapContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapURL);
        contextSource.setBase(this.ldapBaseDN);
        contextSource.setUserDn(this.ldapPrincipal);
        contextSource.setPassword(this.ldapPassword);
        return contextSource;
    }

    private UserDetailsService getUserDetailsService() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        ActiveDirectoryLdapAuthenticationProvider ldapAuthenticationProvider;
        if (StringUtils.isBlank((CharSequence)this.ldapURL)) {
            throw new AuthenticationServiceException("LDAP configuration is missing.");
        }
        if (StringUtils.isBlank((CharSequence)this.adDomain)) {
            LdapContextSource contextSource = new LdapContextSource();
            contextSource.setUrl(this.ldapURL);
            contextSource.setBase(this.ldapBaseDN);
            contextSource.setUserDn(this.ldapPrincipal);
            contextSource.setPassword(this.ldapPassword);
            contextSource.setReferral("follow");
            contextSource.afterPropertiesSet();
            FilterBasedLdapUserSearch ldapUserSearch = new FilterBasedLdapUserSearch(this.ldapSearchBase, this.ldapSearchFilter, (BaseLdapPathContextSource)contextSource);
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)contextSource);
            bindAuthenticator.setUserSearch((LdapUserSearch)ldapUserSearch);
            DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((ContextSource)contextSource, this.ldapGroupSearchBase);
            ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)populator);
        } else {
            ldapAuthenticationProvider = new ActiveDirectoryLdapAuthenticationProvider(this.adDomain, this.ldapURL);
            ldapAuthenticationProvider.setConvertSubErrorCodesToExceptions(true);
            if (!StringUtils.isBlank((CharSequence)this.ldapSearchFilter)) {
                ldapAuthenticationProvider.setSearchFilter(this.ldapSearchFilter);
            }
        }
        return ldapAuthenticationProvider;
    }

    static /* synthetic */ Logger access$000(KerberosSecurityConfiguration x0) {
        return x0.LOG;
    }
}

