/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.servlet;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jscep.server.ScepServlet;
import org.jscep.transaction.FailInfo;
import org.jscep.transaction.OperationFailureException;
import org.jscep.transaction.TransactionId;
import org.jscep.transport.response.Capability;
import org.jscep.util.CertificationRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;

@Controller
public class ScepServletImpl
extends ScepServlet {
    private static final long serialVersionUID = 7773233909179939491L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScepServletImpl.class);
    private static X500Name pollName = new X500Name("CN=Poll");
    @Autowired
    CertificateRepository certRepository;
    @Autowired
    CSRRepository csrRepository;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CertificateProcessingUtil cpUtil;
    @Autowired
    private ProtectedContentRepository protectedContentRepository;
    @Autowired
    private ProtectedContentUtil protectedContentUtil;
    private final PipelineUtil pipelineUtil;
    private final String dnSuffix;
    private final String sans;
    public ThreadLocal<Pipeline> requestPipeline = new ThreadLocal();

    public ScepServletImpl(PipelineUtil pipelineUtil, @Value(value="${ca3s.https.certificate.dnSuffix:O=trustable solutions,C=DE}") String dnSuffix, @Value(value="${ca3s.https.certificate.sans:}") String sans) {
        this.pipelineUtil = pipelineUtil;
        this.dnSuffix = dnSuffix;
        this.sans = sans;
    }

    public void init() throws ServletException {
    }

    Certificate getCurrentRecepientCert() throws ServletException {
        Certificate currentRecepientCert = this.certUtil.getCurrentSCEPRecipient();
        if (currentRecepientCert == null) {
            try {
                KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
                String x500Name = "CN=SCEPRecepient" + System.currentTimeMillis();
                if (!this.dnSuffix.trim().isEmpty()) {
                    x500Name = x500Name + ", " + this.dnSuffix;
                }
                X500Principal subject = new X500Principal(x500Name);
                GeneralName[] sanArray = CertificateUtil.splitSANString((String)this.sans, null);
                String p10ReqPem = CryptoUtil.getCsrAsPEM((X500Principal)subject, (PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate(), (char[])"password".toCharArray());
                LOGGER.debug("created csr for SCEPRecepient '{}':\n'{}'", (Object)x500Name, (Object)p10ReqPem);
                TransactionId tid = new TransactionId(new byte[]{1});
                currentRecepientCert = this.startCertificateCreationProcess(p10ReqPem, tid, null);
                this.certUtil.storePrivateKey(currentRecepientCert, keyPair);
                this.certUtil.setCertAttribute(currentRecepientCert, "CA3S:SCEP_RECIPIENT", "true");
                this.certRepository.save((Object)currentRecepientCert);
            }
            catch (IOException | GeneralSecurityException | OperationFailureException e) {
                throw new ServletException(e);
            }
        }
        return currentRecepientCert;
    }

    private Certificate startCertificateCreationProcess(String csrAsPem, TransactionId transId, Pipeline pipeline) throws OperationFailureException, IOException, GeneralSecurityException {
        Pkcs10RequestHolder p10Holder = this.cryptoUtil.parseCertificateRequest(csrAsPem);
        if (!this.pipelineUtil.isPipelineRestrictionsResolved(pipeline, p10Holder, new ArrayList())) {
            throw new OperationFailureException(FailInfo.badRequest);
        }
        String pipelineName = pipeline == null ? "NoPipeline" : pipeline.getName();
        String requestorName = "SCEP-transId-" + transId.toString();
        LOGGER.debug("doEnrol: processing request by {} using pipeline {}", (Object)requestorName, (Object)pipelineName);
        CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "SCEP_CERTIFICATE_REQUESTED", "", pipeline);
        CsrAttribute csrAttributeTransId = new CsrAttribute();
        csrAttributeTransId.setName("CA3S:SCEP_TRANS_ID");
        csrAttributeTransId.setValue(transId.toString());
        csr.addCsrAttributes(csrAttributeTransId);
        this.csrRepository.save((Object)csr);
        Certificate cert = this.cpUtil.processCertificateRequest(csr, requestorName, "SCEP_CERTIFICATE_CREATED", pipeline);
        if (cert == null) {
            LOGGER.warn("creation of certificate by SCEP transaction id '{}' failed ", (Object)transId);
        } else {
            LOGGER.debug("new certificate id '{}' for SCEP transaction id '{}'", (Object)cert.getId(), (Object)transId);
            this.certUtil.setCertAttribute(cert, "CA3S:SCEP_TRANS_ID", transId.toString());
            this.certRepository.save((Object)cert);
        }
        return cert;
    }

    protected List<X509Certificate> doEnrol(PKCS10CertificationRequest csr, X509Certificate sender, TransactionId transId) throws OperationFailureException {
        LOGGER.debug("doEnrol(" + csr.toString() + ", " + transId.toString() + ")");
        Pipeline pipeline = (Pipeline)this.requestPipeline.get();
        if (pipeline == null) {
            LOGGER.warn("doEnrol: no processing pipeline defined");
            throw new OperationFailureException(FailInfo.badRequest);
        }
        try {
            X500Name subject = X500Name.getInstance((Object)csr.getSubject());
            LOGGER.debug(subject.toString());
            if (subject.equals((Object)pollName)) {
                return Collections.emptyList();
            }
            String password = CertificationRequestUtils.getChallengePassword((PKCS10CertificationRequest)csr);
            this.checkPassword(pipeline, password);
            String p10ReqPem = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)csr);
            Certificate newCertDao = this.startCertificateCreationProcess(p10ReqPem, transId, pipeline);
            if (newCertDao == null) {
                LOGGER.debug("creation of certificate failed");
                throw new OperationFailureException(FailInfo.badRequest);
            }
            this.certUtil.setCertAttribute(newCertDao, "CA3S:SCEP_TRANS_ID", transId.toString());
            this.certRepository.save((Object)newCertDao);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            Certificate chainCert = newCertDao;
            for (int i = 0; i < 3; ++i) {
                if (chainCert == null) continue;
                certList.add(CryptoUtil.convertPemToCertificate((String)chainCert.getContent()));
                chainCert = chainCert.getIssuingCertificate();
            }
            for (X509Certificate x509 : certList) {
                LOGGER.debug("--- chain element: " + x509.getSubjectDN().getName());
            }
            return certList;
        }
        catch (Exception e) {
            LOGGER.warn("Error in enrollment", (Throwable)e);
            throw new OperationFailureException(FailInfo.badRequest);
        }
    }

    void checkPassword(Pipeline pipeline, String password) throws OperationFailureException {
        if (password == null || password.isEmpty()) {
            LOGGER.warn("password not present in SCEP request / is empty!");
            throw new OperationFailureException(FailInfo.badRequest);
        }
        List listPC = this.protectedContentRepository.findByTypeRelationId(ProtectedContentType.PASSWORD, ContentRelationType.SCEP_PW, pipeline.getId());
        for (ProtectedContent pc : listPC) {
            String expectedPassword = this.protectedContentUtil.unprotectString(pc.getContentBase64()).trim();
            if (!password.trim().equals(expectedPassword)) continue;
            LOGGER.debug("Protected Content found matching SCEP password");
            return;
        }
        LOGGER.warn("no (active) password present in pipeline '" + pipeline.getName() + "' !");
        throw new OperationFailureException(FailInfo.badRequest);
    }

    protected List<X509Certificate> doGetCaCertificate(String identifier) {
        LOGGER.debug("doGetCaCertificate(" + identifier + ")");
        List<X509Certificate> caList = new ArrayList<X509Certificate>();
        try {
            Certificate recepCert = this.getCurrentRecepientCert();
            caList = this.certUtil.getX509CertificateChainAsList(recepCert);
        }
        catch (GeneralSecurityException | ServletException e) {
            LOGGER.warn("Failed to retrieve CA certificates", e);
        }
        return caList;
    }

    protected X509CRL doGetCrl(X500Name issuer, BigInteger serial) throws OperationFailureException {
        LOGGER.debug("doGetCrl(" + issuer.toString() + ", " + serial.toString(10) + ")");
        return null;
    }

    protected Set<Capability> doCapabilities(String identifier) {
        LOGGER.debug("doCapabilities(" + identifier + ")");
        return EnumSet.of(Capability.RENEWAL, Capability.SCEP_STANDARD, Capability.SHA_256, Capability.SHA_512, Capability.POST_PKI_OPERATION);
    }

    protected List<X509Certificate> doGetCert(X500Name issuer, BigInteger serial) throws OperationFailureException {
        LOGGER.debug("doGetCert(" + issuer.toString() + ", " + serial.toString() + ")");
        List certDaoList = this.certRepository.findByIssuerSerial(issuer.toString(), serial.toString());
        if (certDaoList.isEmpty()) {
            RDN[] rdns;
            LOGGER.debug("no match for doGetCert(" + issuer + ", " + serial + ")");
            for (RDN rdn : rdns = issuer.getRDNs()) {
                AttributeTypeAndValue[] attTVArr;
                for (AttributeTypeAndValue attTV : attTVArr = rdn.getTypesAndValues()) {
                    LOGGER.debug("AttributeTypeAndValue of issuer :" + attTV.getType().toString() + " = " + attTV.getValue().toString());
                }
            }
            RDN[] rdnsIssuer = issuer.getRDNs(BCStyle.CN);
            if (rdnsIssuer.length > 0) {
                String rdnIssuerString = rdnsIssuer[0].getFirst().getValue().toString();
                LOGGER.debug("looking for doGetCert(" + rdnIssuerString + ", " + serial + ")");
                certDaoList = this.certRepository.findByTermNamed2("ISSUER", rdnIssuerString, "SERIAL", serial.toString());
            }
            if (certDaoList.isEmpty()) {
                throw new OperationFailureException(FailInfo.badCertId);
            }
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (Certificate certDao : certDaoList) {
            try {
                X509Certificate x509Cert = CryptoUtil.convertPemToCertificate((String)certDao.getContent());
                if (x509Cert.getIssuerX500Principal().getName().equals(issuer.toString())) {
                    LOGGER.debug("issuer match for doGetCert(" + issuer + ", " + serial + ")");
                }
                certList.add(x509Cert);
            }
            catch (GeneralSecurityException e) {
                LOGGER.warn("decoding certificate failed", (Throwable)e);
                throw new OperationFailureException(FailInfo.badRequest);
            }
        }
        return certList;
    }

    protected List<X509Certificate> doGetCertInitial(X500Name issuer, X500Name subject, TransactionId transId) {
        LOGGER.debug("doGetCertInitial(" + issuer.toString() + ", " + subject.toString() + ", " + transId.toString() + ")");
        if (subject.equals((Object)pollName)) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected List<X509Certificate> getNextCaCertificate(String identifier) {
        LOGGER.debug("getNextCaCertificate(" + identifier + ")");
        return Collections.emptyList();
    }

    protected PrivateKey getRecipientKey() {
        try {
            return this.certUtil.getPrivateKey(this.getCurrentRecepientCert());
        }
        catch (ServletException e) {
            LOGGER.warn("problem retrieving recipient's private key", (Throwable)e);
            return null;
        }
    }

    protected X509Certificate getRecipient() {
        try {
            X509Certificate ca = CryptoUtil.convertPemToCertificate((String)this.getCurrentRecepientCert().getContent());
            LOGGER.debug("getRecipient() returns " + ca.toString());
            return ca;
        }
        catch (GeneralSecurityException | ServletException e) {
            LOGGER.warn("problem retrieving recipient certificate", e);
            return null;
        }
    }

    protected PrivateKey getSignerKey() {
        LOGGER.debug("getSignerKey(), returning getRecipientKey()");
        return this.getRecipientKey();
    }

    protected X509Certificate getSigner() {
        LOGGER.debug("getSigner(), returning getRecipient()");
        return this.getRecipient();
    }

    protected X509Certificate[] getSignerCertificateChain() {
        LOGGER.debug("getSignerCertificateChain()");
        X509Certificate[] signerChainArr = new X509Certificate[]{};
        try {
            Certificate recepCert = this.getCurrentRecepientCert();
            List certList = this.certUtil.getCertificateChain(recepCert);
            int chainLength = certList.size();
            if (chainLength > 1) {
                signerChainArr = new X509Certificate[chainLength - 1];
                int j = 0;
                for (int i = 1; i < chainLength; ++i) {
                    signerChainArr[j++] = CryptoService.convertPemToCertificate((String)((Certificate)certList.get(i)).getContent());
                }
            }
        }
        catch (GeneralSecurityException | ServletException e) {
            LOGGER.warn("Failed to retrieve CA certificates", e);
        }
        return signerChainArr;
    }
}

