/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import de.trustable.ca3s.core.repository.CSRViewRepository;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.web.rest.CertificateListResource;
import io.github.jhipster.web.util.PaginationUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api"})
public class CSRListResource {
    @Autowired
    CSRViewRepository csrViewRepository;
    private final Logger log = LoggerFactory.getLogger(CSRListResource.class);

    @GetMapping(value={"/csrList"})
    public ResponseEntity<List<CSRView>> getAllCsrs(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CSRViews");
        Page page = this.csrViewRepository.findSelection(request.getParameterMap());
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/csrListCSV"})
    public ResponseEntity<String> getAllCsrAsCSV(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CSRView");
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (String key : request.getParameterMap().keySet()) {
            if (key == "offset" || key == "limit") continue;
            paramMap.put(key, (String[])request.getParameterMap().get(key));
        }
        paramMap.put("offset", new String[]{"0"});
        paramMap.put("limit", new String[]{"1000"});
        Page page = this.csrViewRepository.findSelection(paramMap);
        ArrayList<CSRView> cvList = new ArrayList<CSRView>();
        for (CSRView cv : page.getContent()) {
            Optional optionalCSRView = this.csrViewRepository.findbyCSRId(cv.getId());
            if (!optionalCSRView.isPresent()) continue;
            cvList.add((CSRView)optionalCSRView.get());
            this.log.debug("returning csr #{}", (Object)cv.getId());
        }
        StringWriter writer = new StringWriter();
        ColumnPositionMappingStrategy mappingStrategy = new ColumnPositionMappingStrategy();
        mappingStrategy.setType(CSRView.class);
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withSeparator(';').withApplyQuotesToAll(false).withQuotechar('\"').build();
        try {
            beanToCsv.write(cvList);
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e) {
            this.log.warn("problem building csv response", e);
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok().contentType(CertificateListResource.TEXT_CSV_TYPE).body((Object)((Object)writer).toString());
    }
}

