/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.service.AcmeAuthorizationService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AcmeAuthorizationResource {
    private final Logger log = LoggerFactory.getLogger(AcmeAuthorizationResource.class);
    private static final String ENTITY_NAME = "acmeAuthorization";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeAuthorizationService acmeAuthorizationService;

    public AcmeAuthorizationResource(AcmeAuthorizationService acmeAuthorizationService) {
        this.acmeAuthorizationService = acmeAuthorizationService;
    }

    @PostMapping(value={"/acme-authorizations"})
    public ResponseEntity<AcmeAuthorization> createAcmeAuthorization(@Valid @RequestBody AcmeAuthorization acmeAuthorization) throws URISyntaxException {
        this.log.debug("REST request to save AcmeAuthorization : {}", (Object)acmeAuthorization);
        if (acmeAuthorization.getId() != null) {
            throw new BadRequestAlertException("A new acmeAuthorization cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeAuthorization result = this.acmeAuthorizationService.save(acmeAuthorization);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-authorizations/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-authorizations"})
    public ResponseEntity<AcmeAuthorization> updateAcmeAuthorization(@Valid @RequestBody AcmeAuthorization acmeAuthorization) throws URISyntaxException {
        this.log.debug("REST request to update AcmeAuthorization : {}", (Object)acmeAuthorization);
        if (acmeAuthorization.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeAuthorization result = this.acmeAuthorizationService.save(acmeAuthorization);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeAuthorization.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-authorizations"})
    public List<AcmeAuthorization> getAllAcmeAuthorizations() {
        this.log.debug("REST request to get all AcmeAuthorizations");
        return this.acmeAuthorizationService.findAll();
    }

    @GetMapping(value={"/acme-authorizations/{id}"})
    public ResponseEntity<AcmeAuthorization> getAcmeAuthorization(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeAuthorization : {}", (Object)id);
        Optional acmeAuthorization = this.acmeAuthorizationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeAuthorization);
    }

    @DeleteMapping(value={"/acme-authorizations/{id}"})
    public ResponseEntity<Void> deleteAcmeAuthorization(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeAuthorization : {}", (Object)id);
        this.acmeAuthorizationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

