/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.repository.ACMEAccountRepository;
import de.trustable.ca3s.core.service.ACMEAccountService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ACMEAccountServiceImpl
implements ACMEAccountService {
    private final Logger log = LoggerFactory.getLogger(ACMEAccountServiceImpl.class);
    private final ACMEAccountRepository aCMEAccountRepository;

    public ACMEAccountServiceImpl(ACMEAccountRepository aCMEAccountRepository) {
        this.aCMEAccountRepository = aCMEAccountRepository;
    }

    public ACMEAccount save(ACMEAccount aCMEAccount) {
        this.log.debug("Request to save ACMEAccount : {}", (Object)aCMEAccount);
        return (ACMEAccount)this.aCMEAccountRepository.save((Object)aCMEAccount);
    }

    @Transactional(readOnly=true)
    public List<ACMEAccount> findAll() {
        this.log.debug("Request to get all ACMEAccounts");
        return this.aCMEAccountRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<ACMEAccount> findOne(Long id) {
        this.log.debug("Request to get ACMEAccount : {}", (Object)id);
        return this.aCMEAccountRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ACMEAccount : {}", (Object)id);
        this.aCMEAccountRepository.deleteById((Object)id);
    }
}

