/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvIgnore;
import com.opencsv.bean.CsvRecurse;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.domain.CertificateComment;
import de.trustable.ca3s.core.service.dto.NamedValue;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger LOG = LoggerFactory.getLogger(CertificateView.class);
    @CsvBindByName
    private Long id;
    @CsvIgnore
    private Long csrId;
    @CsvIgnore
    private Long issuerId;
    @CsvIgnore
    private String tbsDigest;
    @CsvBindByName
    private String subject;
    @CsvIgnore
    private String rdn_c;
    @CsvIgnore
    private String rdn_cn;
    @CsvIgnore
    private String rdn_o;
    @CsvIgnore
    private String rdn_ou;
    @CsvIgnore
    private String rdn_s;
    @CsvIgnore
    private String rdn_l;
    @CsvBindByName
    private String sans;
    @CsvBindByName
    private String issuer;
    @CsvBindByName
    private String root;
    @CsvBindByName
    private Boolean trusted;
    @CsvIgnore
    private String fingerprintSha1;
    @CsvIgnore
    private String fingerprintSha256;
    @CsvBindByName
    private String type;
    @CsvBindByName
    private String keyLength;
    @CsvBindByName
    private String keyAlgorithm;
    @CsvIgnore
    private String signingAlgorithm;
    @CsvIgnore
    private String paddingAlgorithm;
    @CsvIgnore
    private String hashAlgorithm;
    @CsvIgnore
    private String description;
    @CsvBindByName
    private String comment;
    @CsvBindByName
    private String csrComment;
    @CsvBindByName
    private String serial;
    @CsvBindByName
    private String serialHex;
    @CsvBindByName
    private Instant validFrom;
    @CsvBindByName
    private Instant validTo;
    private Instant contentAddedAt;
    @CsvBindByName
    private Instant revokedSince;
    @CsvBindByName
    private String revocationReason;
    @CsvBindByName
    private Boolean revoked;
    @CsvBindByName
    private Boolean selfsigned;
    @CsvBindByName
    private Boolean ca;
    @CsvBindByName
    private Boolean intermediate;
    @CsvBindByName
    private Boolean endEntity;
    @CsvBindByName
    private Long chainLength;
    @CsvIgnore
    private String[] usage;
    @CsvBindByName(column="usage")
    private String usageString;
    @CsvIgnore
    private String[] extUsage;
    @CsvBindByName(column="extUsage")
    private String extUsageString;
    @CsvIgnore
    private String[] sanArr;
    @CsvBindByName(column="sans")
    private String sansString;
    @CsvIgnore
    private Long caConnectorId;
    @CsvIgnore
    private Long caProcessingId;
    @CsvBindByName
    private String processingCa;
    @CsvIgnore
    private Long acmeAccountId;
    @CsvIgnore
    private Long acmeOrderId;
    @CsvIgnore
    private String scepTransId;
    @CsvIgnore
    private String scepRecipient;
    @CsvIgnore
    private String fileSource;
    @CsvBindByName
    private String uploadedBy;
    @CsvBindByName
    private String revokedBy;
    @CsvBindByName
    private String requestedBy;
    @CsvBindByName
    private String crlUrl;
    @CsvIgnore
    private Instant crlNextUpdate;
    @CsvIgnore
    private String certB64;
    @CsvIgnore
    private String downloadFilename;
    @CsvIgnore
    private Boolean isServersideKeyGeneration = false;
    @CsvIgnore
    private Boolean isAuditPresent = false;
    @CsvIgnore
    private String[] replacedCertArr;
    @CsvRecurse
    private NamedValue[] arArr;

    public CertificateView() {
    }

    public CertificateView(Certificate cert) {
        this.id = cert.getId();
        this.tbsDigest = cert.getTbsDigest();
        this.subject = cert.getSubject();
        this.sans = cert.getSans();
        this.issuer = cert.getIssuer();
        this.type = cert.getType();
        this.keyLength = cert.getKeyLength().toString();
        this.keyAlgorithm = cert.getKeyAlgorithm();
        this.signingAlgorithm = cert.getSigningAlgorithm();
        this.paddingAlgorithm = cert.getPaddingAlgorithm();
        this.hashAlgorithm = cert.getHashingAlgorithm();
        this.description = cert.getDescription();
        this.serial = cert.getSerial();
        try {
            BigInteger bi = new BigInteger(this.serial);
            this.serialHex = bi.toString(16);
        }
        catch (NumberFormatException nfe) {
            this.serialHex = "";
        }
        this.validFrom = cert.getValidFrom();
        this.validTo = cert.getValidTo();
        this.contentAddedAt = cert.getContentAddedAt();
        this.revokedSince = cert.getRevokedSince();
        this.revocationReason = cert.getRevocationReason();
        this.revoked = cert.isRevoked();
        this.trusted = cert.isTrusted();
        this.certB64 = cert.getContent();
        this.csrComment = "";
        CSR csr = cert.getCsr();
        if (csr != null) {
            this.requestedBy = csr.getRequestedBy();
            this.csrId = csr.getId();
            this.isServersideKeyGeneration = csr.isServersideKeyGeneration();
            if (csr.getComment() != null) {
                this.csrComment = csr.getComment().getComment();
            }
        } else {
            this.requestedBy = "";
        }
        if (cert.getIssuingCertificate() != null) {
            this.issuerId = cert.getIssuingCertificate().getId();
        }
        ArrayList<String> usageList = new ArrayList<String>();
        ArrayList<String> extUsageList = new ArrayList<String>();
        ArrayList<String> sanList = new ArrayList<String>();
        ArrayList<String> replacedCertList = new ArrayList<String>();
        this.usageString = "";
        this.extUsageString = "";
        this.sansString = "";
        for (CertificateAttribute certAttr : cert.getCertificateAttributes()) {
            try {
                if ("CA_CONNECTOR_ID".equalsIgnoreCase(certAttr.getName())) {
                    this.caConnectorId = Long.parseLong(certAttr.getValue());
                    continue;
                }
                if ("CA_PROCESSING_ID".equalsIgnoreCase(certAttr.getName())) {
                    this.caProcessingId = Long.parseLong(certAttr.getValue());
                    continue;
                }
                if ("PROCESSING_CA".equalsIgnoreCase(certAttr.getName())) {
                    this.processingCa = certAttr.getValue();
                    continue;
                }
                if ("SOURCE".equalsIgnoreCase(certAttr.getName())) {
                    this.fileSource = certAttr.getValue();
                    continue;
                }
                if ("UPLOADED_BY".equalsIgnoreCase(certAttr.getName())) {
                    this.uploadedBy = certAttr.getValue();
                    continue;
                }
                if ("REVOKED_BY".equalsIgnoreCase(certAttr.getName())) {
                    this.revokedBy = certAttr.getValue();
                    continue;
                }
                if ("CRL_URL".equalsIgnoreCase(certAttr.getName())) {
                    this.crlUrl = certAttr.getValue();
                    continue;
                }
                if ("FINGERPRINT_SHA1".equalsIgnoreCase(certAttr.getName())) {
                    this.fingerprintSha1 = certAttr.getValue();
                    continue;
                }
                if ("FINGERPRINT_SHA256".equalsIgnoreCase(certAttr.getName())) {
                    this.fingerprintSha256 = certAttr.getValue();
                    continue;
                }
                if ("RDN_COMMONNAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_cn = certAttr.getValue();
                    continue;
                }
                if ("RDN_COUNTRYNAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_c = certAttr.getValue();
                    continue;
                }
                if ("RDN_ORGANIZATIONNAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_o = certAttr.getValue();
                    continue;
                }
                if ("RDN_ORGANIZATIONALUNITNAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_ou = certAttr.getValue();
                    continue;
                }
                if ("RDN_LOCALITYNAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_l = certAttr.getValue();
                    continue;
                }
                if ("RDN_STATEORPROVINCENAME".equalsIgnoreCase(certAttr.getName())) {
                    this.rdn_s = certAttr.getValue();
                    continue;
                }
                if ("CRL_NEXT_UPDATE".equalsIgnoreCase(certAttr.getName())) {
                    this.crlNextUpdate = Instant.ofEpochMilli(Long.parseLong(certAttr.getValue()));
                    continue;
                }
                if ("ACME:ACCOUNT_ID".equalsIgnoreCase(certAttr.getName())) {
                    this.acmeAccountId = Long.parseLong(certAttr.getValue());
                    continue;
                }
                if ("ACME:ORDER_ID".equalsIgnoreCase(certAttr.getName())) {
                    this.acmeOrderId = Long.parseLong(certAttr.getValue());
                    continue;
                }
                if ("CA3S:SCEP_RECIPIENT".equalsIgnoreCase(certAttr.getName())) {
                    this.scepRecipient = certAttr.getValue();
                    continue;
                }
                if ("CA3S:SCEP_TRANS_ID".equalsIgnoreCase(certAttr.getName())) {
                    this.scepTransId = certAttr.getValue();
                    continue;
                }
                if ("CA3S:SELFSIGNED".equalsIgnoreCase(certAttr.getName())) {
                    this.selfsigned = Boolean.valueOf(certAttr.getValue());
                    continue;
                }
                if ("CA3S:CA".equalsIgnoreCase(certAttr.getName())) {
                    this.ca = Boolean.valueOf(certAttr.getValue());
                    continue;
                }
                if ("CA3S:ROOT".equalsIgnoreCase(certAttr.getName()) || "ROOT".equalsIgnoreCase(certAttr.getName()) || "CA3S:INTERMEDIATE".equalsIgnoreCase(certAttr.getName())) continue;
                if ("CA3S:END_ENTITY".equalsIgnoreCase(certAttr.getName())) {
                    this.endEntity = Boolean.valueOf(certAttr.getValue());
                    continue;
                }
                if ("CA3S:CHAIN_LENGTH".equalsIgnoreCase(certAttr.getName())) {
                    this.chainLength = Long.parseLong(certAttr.getValue());
                    continue;
                }
                if ("USAGE".equalsIgnoreCase(certAttr.getName())) {
                    usageList.add(certAttr.getValue());
                    this.usageString = this.usageString.isEmpty() ? certAttr.getValue() : this.usageString + ", " + certAttr.getValue();
                    continue;
                }
                if ("EXTENDED_USAGE".equalsIgnoreCase(certAttr.getName())) {
                    extUsageList.add(certAttr.getValue());
                    this.extUsageString = this.extUsageString.isEmpty() ? certAttr.getValue() : this.extUsageString + ", " + certAttr.getValue();
                    continue;
                }
                if ("SAN".equalsIgnoreCase(certAttr.getName())) {
                    sanList.add(certAttr.getValue());
                    this.sansString = this.sansString.isEmpty() ? certAttr.getValue() : this.sansString + ", " + certAttr.getValue();
                    continue;
                }
                if ("REPLACED_BY".equalsIgnoreCase(certAttr.getName())) {
                    replacedCertList.add(certAttr.getValue());
                    continue;
                }
                this.LOG.debug("Irrelevant certificate attribute '{}' with value '{}'", (Object)certAttr.getName(), (Object)certAttr.getValue());
            }
            catch (NumberFormatException nfe) {
                this.LOG.warn("Number parsing problem for certificate attribute '{}' with value '{}'", (Object)certAttr.getName(), (Object)certAttr.getValue());
            }
        }
        this.usage = usageList.toArray(new String[0]);
        this.extUsage = extUsageList.toArray(new String[0]);
        this.sanArr = sanList.toArray(new String[0]);
        this.replacedCertArr = replacedCertList.toArray(new String[0]);
        this.downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
        this.arArr = this.copyArAttributes(cert);
        CertificateComment comment = cert.getComment() == null ? new CertificateComment() : cert.getComment();
        this.setComment(comment.getComment() == null ? "" : comment.getComment());
    }

    public Long getId() {
        return this.id;
    }

    public String getTbsDigest() {
        return this.tbsDigest;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSerial() {
        return this.serial;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Instant getValidTo() {
        return this.validTo;
    }

    public Instant getContentAddedAt() {
        return this.contentAddedAt;
    }

    public Instant getRevokedSince() {
        return this.revokedSince;
    }

    public String getRevocationReason() {
        return this.revocationReason;
    }

    public Boolean getRevoked() {
        return this.revoked;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTbsDigest(String tbsDigest) {
        this.tbsDigest = tbsDigest;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSerial(String serial) {
        this.serial = serial;
        try {
            BigInteger bi = new BigInteger(serial);
            this.serialHex = bi.toString(16);
        }
        catch (NumberFormatException nfe) {
            this.serialHex = "";
        }
    }

    public void setValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(Instant validTo) {
        this.validTo = validTo;
    }

    public void setContentAddedAt(Instant contentAddedAt) {
        this.contentAddedAt = contentAddedAt;
    }

    public void setRevokedSince(Instant revokedSince) {
        this.revokedSince = revokedSince;
    }

    public void setRevocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
    }

    public String getKeyLength() {
        return this.keyLength;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getPaddingAlgorithm() {
        return this.paddingAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setKeyLength(String keyLength) {
        this.keyLength = keyLength;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public void setPaddingAlgorithm(String paddingAlgorithm) {
        this.paddingAlgorithm = paddingAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getSans() {
        return this.sans;
    }

    public void setSans(String sans) {
        this.sans = sans;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public Boolean getSelfsigned() {
        return this.selfsigned;
    }

    public Boolean getCa() {
        return this.ca;
    }

    public String getRoot() {
        return this.root;
    }

    public Boolean getIntermediate() {
        return this.intermediate;
    }

    public Boolean getEndEntity() {
        return this.endEntity;
    }

    public Long getChainLength() {
        return this.chainLength;
    }

    public String[] getUsage() {
        return this.usage;
    }

    public String[] getSanArr() {
        return this.sanArr;
    }

    public Long getCaConnectorId() {
        return this.caConnectorId;
    }

    public Long getCaProcessingId() {
        return this.caProcessingId;
    }

    public String getFileSource() {
        return this.fileSource;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public String getRevokedBy() {
        return this.revokedBy;
    }

    public String getCrlUrl() {
        return this.crlUrl;
    }

    public Instant getCrlNextUpdate() {
        return this.crlNextUpdate;
    }

    public void setSelfsigned(Boolean selfsigned) {
        this.selfsigned = selfsigned;
    }

    public void setCa(Boolean ca) {
        this.ca = ca;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setIntermediate(Boolean intermediate) {
        this.intermediate = intermediate;
    }

    public void setEndEntity(Boolean endEntity) {
        this.endEntity = endEntity;
    }

    public void setChainLength(Long chainLength) {
        this.chainLength = chainLength;
    }

    public void setUsage(String[] usage) {
        this.usage = usage;
    }

    public void setSanArr(String[] sanArr) {
        this.sanArr = sanArr;
    }

    public void setCaConnectorId(Long caConnectorId) {
        this.caConnectorId = caConnectorId;
    }

    public void setCaProcessingId(Long caProcessingId) {
        this.caProcessingId = caProcessingId;
    }

    public void setFileSource(String fileSource) {
        this.fileSource = fileSource;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public void setRevokedBy(String revokedBy) {
        this.revokedBy = revokedBy;
    }

    public void setCrlUrl(String crlUrl) {
        this.crlUrl = crlUrl;
    }

    public void setCrlNextUpdate(Instant crlNextUpdate) {
        this.crlNextUpdate = crlNextUpdate;
    }

    public Long getAcmeAccountId() {
        return this.acmeAccountId;
    }

    public Long getAcmeOrderId() {
        return this.acmeOrderId;
    }

    public String getScepTransId() {
        return this.scepTransId;
    }

    public String getScepRecipient() {
        return this.scepRecipient;
    }

    public void setAcmeAccountId(Long acmeAccountId) {
        this.acmeAccountId = acmeAccountId;
    }

    public void setAcmeOrderId(Long acmeOrderId) {
        this.acmeOrderId = acmeOrderId;
    }

    public void setScepTransId(String scepTransId) {
        this.scepTransId = scepTransId;
    }

    public void setScepRecipient(String scepRecipient) {
        this.scepRecipient = scepRecipient;
    }

    public String[] getExtUsage() {
        return this.extUsage;
    }

    public void setExtUsage(String[] extUsage) {
        this.extUsage = extUsage;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public String getDownloadFilename() {
        return this.downloadFilename;
    }

    public void setDownloadFilename(String downloadFilename) {
        this.downloadFilename = downloadFilename;
    }

    public Long getCsrId() {
        return this.csrId;
    }

    public Long getIssuerId() {
        return this.issuerId;
    }

    public void setCsrId(Long csrId) {
        this.csrId = csrId;
    }

    public void setIssuerId(Long issuerId) {
        this.issuerId = issuerId;
    }

    public String getFingerprintSha1() {
        return this.fingerprintSha1;
    }

    public void setFingerprintSha1(String fingerprint) {
        this.fingerprintSha1 = fingerprint;
    }

    public String getFingerprintSha256() {
        return this.fingerprintSha256;
    }

    public void setFingerprintSha256(String fingerprint) {
        this.fingerprintSha256 = fingerprint;
    }

    public String getProcessingCa() {
        return this.processingCa;
    }

    public void setProcessingCa(String processingCa) {
        this.processingCa = processingCa;
    }

    public String getCertB64() {
        return this.certB64;
    }

    public void setCertB64(String certB64) {
        this.certB64 = certB64;
    }

    public Boolean getIsServersideKeyGeneration() {
        return this.isServersideKeyGeneration;
    }

    public void setIsServersideKeyGeneration(Boolean isServersideKeyGeneration) {
        this.isServersideKeyGeneration = isServersideKeyGeneration;
    }

    public String getRdn_c() {
        return this.rdn_c;
    }

    public void setRdn_c(String rdn_c) {
        this.rdn_c = rdn_c;
    }

    public String getRdn_cn() {
        return this.rdn_cn;
    }

    public void setRdn_cn(String rdn_cn) {
        this.rdn_cn = rdn_cn;
    }

    public String getRdn_o() {
        return this.rdn_o;
    }

    public void setRdn_o(String rdn_o) {
        this.rdn_o = rdn_o;
    }

    public String getRdn_ou() {
        return this.rdn_ou;
    }

    public void setRdn_ou(String rdn_ou) {
        this.rdn_ou = rdn_ou;
    }

    public String getRdn_s() {
        return this.rdn_s;
    }

    public void setRdn_s(String rdn_s) {
        this.rdn_s = rdn_s;
    }

    public String getRdn_l() {
        return this.rdn_l;
    }

    public void setRdn_l(String rdn_l) {
        this.rdn_l = rdn_l;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCsrComment() {
        return this.csrComment;
    }

    public void setCsrComment(String csrComment) {
        this.csrComment = csrComment;
    }

    public NamedValue[] getArArr() {
        return this.arArr;
    }

    public void setArArr(NamedValue[] arArr) {
        this.arArr = arArr;
    }

    private NamedValue[] copyArAttributes(Certificate cert) {
        ArrayList<NamedValue> nvList = new ArrayList<NamedValue>();
        for (CertificateAttribute certAttr : cert.getCertificateAttributes()) {
            if (!certAttr.getName().startsWith("_ARA_")) continue;
            NamedValue nv = new NamedValue();
            nv.setName(certAttr.getName().substring("_ARA_".length()));
            nv.setValue(certAttr.getValue());
            nvList.add(nv);
        }
        return nvList.toArray(new NamedValue[0]);
    }

    public Boolean getAuditPresent() {
        return this.isAuditPresent;
    }

    public void setAuditPresent(Boolean auditPresent) {
        this.isAuditPresent = auditPresent;
    }

    public Boolean getTrusted() {
        return this.trusted;
    }

    public void setTrusted(Boolean trusted) {
        this.trusted = trusted;
    }

    public String getUsageString() {
        return this.usageString;
    }

    public void setUsageString(String usageString) {
        this.usageString = usageString;
    }

    public String getExtUsageString() {
        return this.extUsageString;
    }

    public void setExtUsageString(String extUsageString) {
        this.extUsageString = extUsageString;
    }

    public String getSansString() {
        return this.sansString;
    }

    public void setSansString(String sansString) {
        this.sansString = sansString;
    }

    public Boolean getServersideKeyGeneration() {
        return this.isServersideKeyGeneration;
    }

    public void setServersideKeyGeneration(Boolean serversideKeyGeneration) {
        this.isServersideKeyGeneration = serversideKeyGeneration;
    }

    public String getSerialHex() {
        return this.serialHex;
    }

    public void setSerialHex(String serialHex) {
        this.serialHex = serialHex;
    }

    public String[] getReplacedCertArr() {
        return this.replacedCertArr;
    }

    public void setReplacedCertArr(String[] replacedCertArr) {
        this.replacedCertArr = replacedCertArr;
    }
}

