/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.cmp;

import de.trustable.ca3s.core.security.provider.Ca3sTrustManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class RemoteConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteConnector.class);
    private final Environment environment;
    private final Ca3sTrustManager ca3sTrustManager;

    public RemoteConnector(Environment environment, Ca3sTrustManager ca3sTrustManager) {
        this.environment = environment;
        this.ca3sTrustManager = ca3sTrustManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendHttpReq(String requestUrlParam, byte[] requestBytes) throws IOException {
        if (requestUrlParam == null) {
            throw new IllegalArgumentException("requestUrlParam can not be null.");
        }
        String port = this.environment.getProperty("local.server.port");
        LOGGER.debug("current port is " + port);
        String requestUrl = requestUrlParam;
        if (requestUrl.contains("${server.port}")) {
            requestUrl = requestUrl.replace("${server.port}", "" + port);
        }
        if (requestUrl.contains(":0/")) {
            requestUrl = requestUrl.replace(":0/", ":" + port + "/");
        }
        LOGGER.debug("Sending request to: " + requestUrl);
        long startTime = System.currentTimeMillis();
        URL url = new URL(requestUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if ("https".equals(url.getProtocol())) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{this.ca3sTrustManager}, new SecureRandom());
                HttpsURLConnection conTLS = (HttpsURLConnection)con;
                conTLS.setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("problem configuring the SSLContext", e);
            }
        } else if (!"http".equals(url.getProtocol())) {
            throw new IOException("Unexpected protocol '" + url.getProtocol() + "'");
        }
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/octet-stream;charset=UTF-8");
        OutputStream os = con.getOutputStream();
        os.write(requestBytes);
        os.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = null;){
            in = con.getInputStream();
            byte[] tmpBA = new byte[4096];
            int nBytes = 0;
            while ((nBytes = in.read(tmpBA)) > 0) {
                baos.write(tmpBA, 0, nBytes);
            }
            LOGGER.debug("# " + baos.size() + " response bytes recieved");
        }
        if (con.getResponseCode() != 200) {
            throw new IOException("Error sending CMP request. Response codse != 200 : " + con.getResponseCode());
        }
        LOGGER.debug("Received certificate reply.");
        con.disconnect();
        LOGGER.debug("duration of remote CMP call " + (System.currentTimeMillis() - startTime));
        return baos.toByteArray();
    }
}

