/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.cmp;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.RDNAttribute;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.cmp.RemoteConnector;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaCmpConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaCmpConnector.class);
    @Autowired
    private RemoteConnector remoteConnector;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CSRUtil csrUtil;
    @Autowired
    private ProtectedContentUtil protUtil;
    @Autowired
    private CertificateRepository certificateRepository;

    public CaCmpConnector() {
        LOGGER.info("CaCmpConnector cTor ...");
    }

    public de.trustable.ca3s.core.domain.Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        long certReqId = new Random().nextLong();
        try {
            LOGGER.debug("csr contains #{} CsrAttributes, #{} RequestAttributes and #{} RDN", new Object[]{csr.getCsrAttributes().size(), csr.getRas().size(), csr.getRdns().size()});
            String plainSecret = this.protUtil.unprotectString(caConnConfig.getSecret().getContentBase64());
            PKIMessage pkiRequest = this.buildCertRequest(certReqId, csr, plainSecret);
            byte[] requestBytes = pkiRequest.getEncoded();
            LOGGER.debug("requestBytes : " + Base64.getEncoder().encodeToString(requestBytes));
            LOGGER.debug("cmp connector '{}' has url '{}' with alias '{}' ", new Object[]{caConnConfig.getName(), caConnConfig.getCaUrl(), caConnConfig.getSelector()});
            byte[] responseBytes = this.remoteConnector.sendHttpReq(caConnConfig.getCaUrl() + "/" + caConnConfig.getSelector(), requestBytes);
            if (responseBytes == null) {
                throw new GeneralSecurityException("remote connector returned 'null'");
            }
            LOGGER.debug("responseBytes : " + Base64.getEncoder().encodeToString(responseBytes));
            de.trustable.ca3s.core.domain.Certificate cert = this.readCertResponse(responseBytes, pkiRequest, csr, caConnConfig);
            csr.setCertificate(cert);
            csr.setStatus(CsrStatus.ISSUED);
            return cert;
        }
        catch (CRMFException e) {
            LOGGER.info("CMS format problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (CMPException e) {
            LOGGER.info("CMP problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.info("IO / encoding problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    public void revokeCertificate(X509Certificate x509Cert, CRLReason crlReason, String hmacSecret, String cmpEndpoint, String alias) throws GeneralSecurityException {
        this.revokeCertificate(JcaX500NameUtil.getIssuer((X509Certificate)x509Cert), JcaX500NameUtil.getSubject((X509Certificate)x509Cert), x509Cert.getSerialNumber(), crlReason, hmacSecret, cmpEndpoint, alias);
    }

    public void revokeCertificate(de.trustable.ca3s.core.domain.Certificate certDao, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        String plainSecret = this.protUtil.unprotectString(caConnConfig.getSecret().getContentBase64());
        this.revokeCertificate(new X500Name(certDao.getIssuer()), new X500Name(certDao.getSubject()), new BigInteger(certDao.getSerial()), crlReason, plainSecret, caConnConfig.getCaUrl(), caConnConfig.getSelector());
    }

    public void revokeCertificate(X500Name issuerDN, X500Name subjectDN, BigInteger serial, CRLReason crlReason, String hmacSecret, String cmpEndpoint, String alias) throws GeneralSecurityException {
        long certRevId = new Random().nextLong();
        try {
            byte[] revocationRequestBytes = this.cryptoUtil.buildRevocationRequest(certRevId, issuerDN, subjectDN, serial, crlReason, hmacSecret);
            LOGGER.info("revocation requestBytes : " + Base64.getEncoder().encodeToString(revocationRequestBytes));
            byte[] responseBytes = this.remoteConnector.sendHttpReq(cmpEndpoint + "/" + alias, revocationRequestBytes);
            LOGGER.info("revocation responseBytes : " + Base64.getEncoder().encodeToString(responseBytes));
            this.cryptoUtil.readRevResponse(responseBytes, hmacSecret);
            return;
        }
        catch (CRMFException e) {
            LOGGER.info("CMS format problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (CMPException e) {
            LOGGER.info("CMP problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.info("IO / encoding problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    public PKIMessage buildCertRequest(long certReqId, CSR csr, String hmacSecret) throws GeneralSecurityException {
        PKCS10CertificationRequest p10Req;
        try {
            p10Req = this.cryptoUtil.parseCertificateRequest(csr.getCsrBase64()).getP10Req();
        }
        catch (IOException e) {
            LOGGER.error("parsing csr", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        ArrayList<RDN> rdnList = new ArrayList<RDN>();
        for (de.trustable.ca3s.core.domain.RDN rdnDao : csr.getRdns()) {
            LOGGER.debug("rdnDao : " + rdnDao.getRdnAttributes());
            Attribute[] attrTVList = new ArrayList();
            if (rdnDao != null && rdnDao.getRdnAttributes() != null) {
                for (RDNAttribute rdnAttr : rdnDao.getRdnAttributes()) {
                    ASN1ObjectIdentifier aoi = new ASN1ObjectIdentifier(rdnAttr.getAttributeType());
                    DERUTF8String ae = new DERUTF8String(rdnAttr.getAttributeValue());
                    AttributeTypeAndValue attrTV = new AttributeTypeAndValue(aoi, (ASN1Encodable)ae);
                    attrTVList.add(attrTV);
                }
            }
            RDN rdn = new RDN(attrTVList.toArray(new AttributeTypeAndValue[attrTVList.size()]));
            LOGGER.debug("rdn : " + rdn.size() + " elements");
            rdnList.add(rdn);
        }
        X500Name subjectDN = new X500Name(rdnList.toArray(new RDN[rdnList.size()]));
        LOGGER.debug("subjectDN : " + subjectDN);
        ArrayList<Extension> certExtList = new ArrayList<Extension>();
        for (Attribute attribute : p10Req.getAttributes()) {
            for (ASN1Encodable asn1Encodable : attribute.getAttributeValues()) {
                if (asn1Encodable == null) continue;
                Extensions extensions = Extensions.getInstance((Object)asn1Encodable);
                for (ASN1ObjectIdentifier oid : extensions.getExtensionOIDs()) {
                    LOGGER.debug("copying oid '" + oid.toString() + "' from csr to PKIMessage");
                    certExtList.add(extensions.getExtension(oid));
                }
            }
        }
        SubjectPublicKeyInfo keyInfo = p10Req.getSubjectPublicKeyInfo();
        return this.cryptoUtil.buildCertRequest(certReqId, subjectDN, certExtList, keyInfo, hmacSecret);
    }

    PKIMessage buildCertRequest(long certReqId, PKCS10CertificationRequest p10Req, String hmacSecret) throws GeneralSecurityException {
        Attribute[] attrs;
        X500Name subjectDN = p10Req.getSubject();
        ArrayList<Extension> certExtList = new ArrayList<Extension>();
        for (Attribute attr : attrs = p10Req.getAttributes()) {
            for (ASN1Encodable asn1Enc : attr.getAttributeValues()) {
                boolean critical = false;
                try {
                    Extension ext = new Extension(attr.getAttrType(), critical, asn1Enc.toASN1Primitive().getEncoded());
                    LOGGER.debug("Csr Extension from PKCS10Attr : " + ext.getExtnId().getId() + " -> " + ext.getParsedValue().toString());
                    certExtList.add(ext);
                }
                catch (IOException e) {
                    LOGGER.error("reading attribute", (Throwable)e);
                    throw new GeneralSecurityException(e.getMessage());
                }
            }
        }
        return this.cryptoUtil.buildCertRequest(certReqId, subjectDN, certExtList, p10Req.getSubjectPublicKeyInfo(), hmacSecret);
    }

    public CAStatus getStatus(CAConnectorConfig caConnConfig) {
        try {
            InfoTypeAndValue[] infoTypeAndValueArr;
            if (caConnConfig.getSecret() == null) {
                LOGGER.error("CMP instance requires 'secret' to be present");
                return CAStatus.Deactivated;
            }
            String plainSecret = this.protUtil.unprotectString(caConnConfig.getSecret().getContentBase64());
            GenMsgContent infoContent = this.getGeneralInfo(plainSecret, caConnConfig.getCaUrl(), caConnConfig.getSelector());
            for (InfoTypeAndValue infoTypeAndValue : infoTypeAndValueArr = infoContent.toInfoTypeAndValueArray()) {
                LOGGER.debug("CMP instance {} returns {}: {}", new Object[]{caConnConfig.getName(), infoTypeAndValue.getInfoType().getId(), infoTypeAndValue.getInfoValue().toString()});
            }
            return CAStatus.Active;
        }
        catch (UnrecoverableEntryException ree) {
            return CAStatus.Active;
        }
        catch (GeneralSecurityException gse) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("status call to CMP instance '" + caConnConfig.getName() + "' failed", (Throwable)gse);
            } else {
                LOGGER.error("status call to CMP instance '" + caConnConfig.getName() + "' failed: " + gse.getMessage());
            }
            return CAStatus.Deactivated;
        }
    }

    public GenMsgContent getGeneralInfo(String hmacSecret, String cmpEndpoint, String alias) throws GeneralSecurityException {
        try {
            PKIMessage pkiMessage = this.cryptoUtil.buildGeneralMessageRequest(hmacSecret);
            LOGGER.debug("general info requestBytes : " + Base64.getEncoder().encodeToString(pkiMessage.getEncoded()));
            byte[] responseBytes = this.remoteConnector.sendHttpReq(cmpEndpoint + "/" + alias, pkiMessage.getEncoded());
            LOGGER.debug("general info responseBytes : " + Base64.getEncoder().encodeToString(responseBytes));
            return this.cryptoUtil.readGenMsgResponse(responseBytes, hmacSecret);
        }
        catch (CRMFException e) {
            LOGGER.info("CMS format problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (CMPException e) {
            LOGGER.info("CMP problem", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("IO / encoding problem", (Throwable)e);
            } else {
                LOGGER.info("IO / encoding problem: {}", (Object)e.getMessage());
            }
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    public de.trustable.ca3s.core.domain.Certificate readCertResponse(byte[] responseBytes, PKIMessage pkiMessageReq, CSR csr, CAConnectorConfig config) throws IOException, CRMFException, CMPException, GeneralSecurityException {
        ASN1Primitive derObject = this.cryptoUtil.getDERObject(responseBytes);
        PKIMessage pkiMessage = PKIMessage.getInstance((Object)derObject);
        if (pkiMessage == null) {
            throw new GeneralSecurityException("No CMP message could be parsed from received Der object.");
        }
        this.printPKIMessageInfo(pkiMessage);
        PKIHeader pkiHeaderReq = pkiMessageReq.getHeader();
        PKIHeader pkiHeaderResp = pkiMessage.getHeader();
        if (!pkiHeaderReq.getSenderNonce().equals((ASN1Primitive)pkiHeaderResp.getRecipNonce())) {
            ASN1OctetString asn1Oct = pkiHeaderResp.getRecipNonce();
            if (asn1Oct == null) {
                LOGGER.info("Recip nonce  == null");
            } else {
                LOGGER.info("sender nonce " + Base64.getEncoder().encodeToString(pkiHeaderReq.getSenderNonce().getOctets()) + " != " + Base64.getEncoder().encodeToString(asn1Oct.getOctets()));
            }
            throw new GeneralSecurityException("Sender / Recip nonce mismatch");
        }
        if (!pkiHeaderReq.getTransactionID().equals((ASN1Primitive)pkiHeaderResp.getTransactionID())) {
            ASN1OctetString asn1Oct = pkiHeaderResp.getTransactionID();
            if (asn1Oct == null) {
                LOGGER.info("transaction id == null");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("transaction id " + Base64.getEncoder().encodeToString(pkiHeaderReq.getTransactionID().getOctets()) + " != " + Base64.getEncoder().encodeToString(asn1Oct.getOctets()));
            }
            throw new GeneralSecurityException("Sender / Recip Transaction Id mismatch");
        }
        PKIBody body = pkiMessage.getBody();
        int tagno = body.getType();
        if (tagno == 23) {
            this.handleCMPError(body);
        } else if (tagno == 3 || tagno == 1) {
            CertResponse[] respArr;
            int i;
            CertRepMessage certRepMessage = CertRepMessage.getInstance((Object)body.getContent());
            try {
                CMPCertificate[] cmpCertArr = pkiMessage.getExtraCerts();
                LOGGER.info("CMP Response body contains " + cmpCertArr.length + " extra certificates");
                for (i = 0; i < cmpCertArr.length; ++i) {
                    CMPCertificate cmpCert = cmpCertArr[i];
                    LOGGER.info("Added CA '" + cmpCert.getX509v3PKCert().getSubject() + "' from CMP Response body");
                    de.trustable.ca3s.core.domain.Certificate certDao = this.certUtil.createCertificate(cmpCert.getEncoded(), null, null, true);
                    this.certificateRepository.save((Object)certDao);
                    LOGGER.debug("Additional CA '" + certDao.getSubject() + "' from CMP Response body");
                }
            }
            catch (NullPointerException cmpCertArr) {
                // empty catch block
            }
            if ((respArr = certRepMessage.getResponse()) == null || respArr.length == 0) {
                throw new GeneralSecurityException("No CMP response found.");
            }
            LOGGER.info("CMP Response body contains " + respArr.length + " elements");
            for (i = 0; i < respArr.length; ++i) {
                Certificate cmpCertificate;
                PKIFreeText freeText;
                if (respArr[i] == null) {
                    throw new GeneralSecurityException("No CMP response returned.");
                }
                BigInteger status = BigInteger.ZERO;
                String statusText = "";
                PKIStatusInfo pkiStatusInfo = respArr[i].getStatus();
                if (pkiStatusInfo != null && (freeText = pkiStatusInfo.getStatusString()) != null) {
                    for (int j = 0; j < freeText.size(); ++j) {
                        statusText = freeText.getStringAt(j) + "\n";
                    }
                }
                if (respArr[i].getCertifiedKeyPair() == null || respArr[i].getCertifiedKeyPair().getCertOrEncCert() == null) {
                    this.csrUtil.setStatus(csr, CsrStatus.REJECTED);
                    this.csrUtil.setCsrAttribute(csr, "REJECTION_INFO", statusText, true);
                    throw new GeneralSecurityException("CMP response contains no certificate, status :" + status + "\n" + statusText);
                }
                CMPCertificate cmpCert = respArr[i].getCertifiedKeyPair().getCertOrEncCert().getCertificate();
                if (cmpCert == null || (cmpCertificate = cmpCert.getX509v3PKCert()) == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("#" + i + ": " + cmpCertificate);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                Collection<? extends java.security.cert.Certificate> certificateChain = certificateFactory.generateCertificates(new ByteArrayInputStream(cmpCertificate.getEncoded()));
                X509Certificate[] certArray = certificateChain.toArray(new X509Certificate[0]);
                X509Certificate cert = certArray[0];
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info("#" + i + ": " + cert);
                }
                de.trustable.ca3s.core.domain.Certificate certDao = this.certUtil.createCertificate(cert.getEncoded(), csr, null, false);
                certDao.setRevocationCA(config);
                this.certificateRepository.save((Object)certDao);
                return certDao;
            }
        } else {
            throw new GeneralSecurityException("unexpected PKI body type :" + tagno);
        }
        return null;
    }

    private void handleCMPError(PKIBody body) throws GeneralSecurityException {
        ErrorMsgContent errMsgContent = ErrorMsgContent.getInstance((Object)body.getContent());
        String errMsg = "errMsg : #" + errMsgContent.getErrorCode() + " " + errMsgContent.getErrorDetails() + " / " + errMsgContent.getPKIStatusInfo().getFailInfo();
        LOGGER.info(errMsg);
        try {
            if (errMsgContent.getPKIStatusInfo() != null) {
                PKIFreeText freeText = errMsgContent.getPKIStatusInfo().getStatusString();
                for (int i = 0; i < freeText.size(); ++i) {
                    LOGGER.info("#" + i + ": " + freeText.getStringAt(i));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        throw new GeneralSecurityException(errMsg);
    }

    private void printPKIMessageInfo(PKIMessage pkiMessage) {
        PKIHeader header = pkiMessage.getHeader();
        PKIBody body = pkiMessage.getBody();
        int tagno = body.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received CMP message with pvno=" + header.getPvno() + ", sender=" + header.getSender().toString() + ", recipient=" + header.getRecipient().toString());
            LOGGER.debug("Body is of type: " + tagno);
            LOGGER.debug("Transaction id: " + header.getTransactionID());
        }
    }
}

