/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;

@Service
public class NotificationService {
    private final Logger LOG = LoggerFactory.getLogger(NotificationService.class);
    @Autowired
    private CertificateRepository certificateRepo;
    @Autowired
    private CSRRepository csrRepo;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private AuditService auditService;

    @Transactional
    public int notifyRAOfficerHolderOnExpiry() throws MessagingException {
        Instant now = Instant.now();
        int nDays = 30;
        Instant after = now;
        Instant before = now.plus((long)nDays, ChronoUnit.DAYS);
        Instant relevantPendingStart = now.minus(nDays, ChronoUnit.DAYS);
        List expiringCertList = this.certificateRepo.findByValidTo(after, before);
        List pendingCsrList = this.csrRepo.findPendingByDay(relevantPendingStart, now);
        if (expiringCertList.isEmpty() && pendingCsrList.isEmpty()) {
            this.LOG.info("No expiring certificates in the next {} days / no pending requests. No need to send a notificaton eMail to RA officers", (Object)nDays);
        } else {
            this.LOG.info("#{} expiring certificate in the next {} days, #{} pending requests", new Object[]{expiringCertList.size(), nDays, pendingCsrList.size()});
            for (User raOfficer : this.findAllRAOfficer()) {
                Locale locale = Locale.forLanguageTag(raOfficer.getLangKey());
                Context context = new Context(locale);
                context.setVariable("expiringCertList", (Object)expiringCertList);
                context.setVariable("pendingCsrList", (Object)pendingCsrList);
                try {
                    this.mailService.sendEmailFromTemplate(context, raOfficer, "mail/pendingReqExpiringCertificateEmail", "email.allExpiringCertificate.subject");
                }
                catch (Throwable throwable) {
                    this.LOG.warn("Problem occured while sending a notificaton eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationfailed(raOfficer.getEmail()));
                }
            }
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationSent(expiringCertList.size()));
        }
        return expiringCertList.size();
    }

    @Async
    public void notifyUserCerificateIssuedAsync(User requestor, Certificate cert) {
        try {
            this.notifyUserCerificateIssued(requestor, cert);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for issued cert", (Throwable)e);
        }
    }

    @Transactional
    public void notifyUserCerificateIssued(User requestor, Certificate cert) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("certId", (Object)cert.getId());
        context.setVariable("subject", (Object)cert.getSubject());
        String downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
        boolean isServersideKeyGeneration = false;
        if (cert.getCsr() != null) {
            isServersideKeyGeneration = cert.getCsr().isServersideKeyGeneration();
        }
        context.setVariable("isServersideKeyGeneration", (Object)isServersideKeyGeneration);
        context.setVariable("filenameCrt", (Object)(downloadFilename + ".crt"));
        context.setVariable("filenamePem", (Object)(downloadFilename + ".pem"));
        this.mailService.sendEmailFromTemplate(context, requestor, "mail/acceptedRequestEmail", "email.acceptedRequest.title");
    }

    @Async
    public void notifyUserCerificateRejectedAsync(User requestor, CSR csr) {
        try {
            this.notifyUserCerificateRejected(requestor, csr);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for rejected request", (Throwable)e);
        }
    }

    @Transactional
    public void notifyUserCerificateRejected(User requestor, CSR csr) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        this.mailService.sendEmailFromTemplate(context, requestor, "mail/rejectedRequestEmail", "email.request.rejection.title");
    }

    @Async
    public void notifyUserCerificateRevokedAsync(User requestor, Certificate cert, CSR csr) {
        try {
            this.notifyUserCerificateRevoked(requestor, cert, csr);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for revoked certificate", (Throwable)e);
        }
    }

    @Transactional
    public void notifyUserCerificateRevoked(User requestor, Certificate cert, CSR csr) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        context.setVariable("cert", (Object)cert);
        String subject = cert.getSubject();
        if (subject == null) {
            subject = "";
        }
        String[] args = new String[]{subject, cert.getSerial(), cert.getIssuer()};
        this.mailService.sendEmailFromTemplate(context, requestor, "mail/revokedCertificateEmail", "email.revokedCertificate.title", args);
    }

    private List<User> findAllRAOfficer() {
        ArrayList<User> raOfficerList = new ArrayList<User>();
        block0: for (User user : this.userRepository.findAll()) {
            for (Authority auth : user.getAuthorities()) {
                this.LOG.debug("user {} {} has role {}", new Object[]{user.getFirstName(), user.getLastName(), auth.getName()});
                if (!"ROLE_RA".equalsIgnoreCase(auth.getName())) continue;
                raOfficerList.add(user);
                this.LOG.debug("found user {} {} having the role of a RA officers", (Object)user.getFirstName(), (Object)user.getLastName());
                continue block0;
            }
        }
        return raOfficerList;
    }
}

