/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.schedule.CertExpiryScheduler;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.util.CRLUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.util.CryptoUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;
import javax.naming.NamingException;
import org.bouncycastle.asn1.x509.CRLReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class CertExpiryScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertExpiryScheduler.class);
    static final int MAX_RECORDS_PER_TRANSACTION = 10000;
    @Autowired
    private CertificateRepository certificateRepo;
    @Autowired
    private CRLUtil crlUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private AuditService auditService;
    @Autowired
    private PreferenceUtil preferenceUtil;
    @Autowired
    private NotificationService notificationService;

    @Scheduled(fixedDelay=3600000L)
    public void retrieveCertificates() {
        Instant now = Instant.now();
        List becomingValidList = this.certificateRepo.findInactiveCertificatesByValidFrom(now);
        int count = 0;
        for (Certificate cert : becomingValidList) {
            cert.setActive(Boolean.valueOf(true));
            this.certificateRepo.save((Object)cert);
            this.LOG.info("Certificate {} becoming active passing 'validFrom'", (Object)cert.getId());
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
        List becomingInvalidList = this.certificateRepo.findActiveCertificatesByValidTo(now);
        count = 0;
        for (Certificate cert : becomingInvalidList) {
            cert.setActive(Boolean.valueOf(false));
            this.certificateRepo.save((Object)cert);
            this.LOG.info("Certificate {} becoming inactive due to expiry", (Object)cert.getId());
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
    }

    @Scheduled(fixedDelay=3600000L)
    public void updateRevocationStatus() {
        if (!this.preferenceUtil.isCheckCrl()) {
            this.LOG.info("Check of CRL status disabled");
            return;
        }
        long excessiveNextUpdate = System.currentTimeMillis() + 2000L * this.preferenceUtil.getMaxNextUpdatePeriodCRLSec();
        long startTime = System.currentTimeMillis();
        HashSet brokenCrlUrlList = new HashSet();
        List certWithURLList = this.certificateRepo.findActiveCertificateOrderedByCrlURL();
        int count = 0;
        for (Object[] resultArr : certWithURLList) {
            block11: {
                Certificate cert = (Certificate)resultArr[0];
                this.LOG.debug("Checking certificate {} for CRL status, URL '{}'", (Object)cert.getId(), resultArr[1]);
                String nextUpdate = this.certUtil.getCertAttribute(cert, "CRL_NEXT_UPDATE");
                if (nextUpdate != null) {
                    try {
                        long nextUpdateMilliSec = Long.parseLong(nextUpdate);
                        if (nextUpdateMilliSec > excessiveNextUpdate) {
                            this.LOG.info("Excessively long CRL validity period for certificate {} ({} sec left), enforcing check.", (Object)cert.getId(), (Object)((nextUpdateMilliSec - startTime) / 1000L));
                        } else if (startTime < nextUpdateMilliSec) {
                            this.LOG.debug("No CRL check for certificate {}, {} sec left ...", (Object)cert.getId(), (Object)((nextUpdateMilliSec - startTime) / 1000L));
                            continue;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.LOG.warn("unexpected value for 'next update' in ATTRIBUTE_CRL_NEXT_UPDATE: {} in cert {}", (Object)nextUpdate, (Object)cert.getId());
                    }
                }
                try {
                    CRLUpdateInfo crlInfo = this.checkAllCRLsForCertificate(cert, CertificateUtil.convertPemToCertificate((String)cert.getContent()), brokenCrlUrlList);
                    if (crlInfo.isbCRLDownloadSuccess()) break block11;
                    this.LOG.info("Downloading all CRL #{} for certificate {} failed", (Object)crlInfo.getCrlUrlCount(), (Object)cert.getId());
                }
                catch (GeneralSecurityException gse) {
                    this.LOG.debug("problem converting certificate id '" + cert.getId() + "' to X509", (Throwable)gse);
                    continue;
                }
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate revocation check to {} per call", (Object)10000);
            break;
        }
        if (!brokenCrlUrlList.isEmpty()) {
            this.LOG.info("#{} CRL URLs marked as inacessable / broken", (Object)brokenCrlUrlList.size());
        }
        this.LOG.info("#{} certificate revocation checks in {} mSec", (Object)count, (Object)(System.currentTimeMillis() - startTime));
    }

    CRLUpdateInfo checkAllCRLsForCertificate(Certificate cert, X509Certificate x509Cert, HashSet<String> brokenCrlUrlList) {
        CRLUpdateInfo info = new CRLUpdateInfo(this);
        long maxNextUpdate = System.currentTimeMillis() + 1000L * this.preferenceUtil.getMaxNextUpdatePeriodCRLSec();
        for (CertificateAttribute certAtt : cert.getCertificateAttributes()) {
            if (!"CRL_URL".equals(certAtt.getName())) continue;
            String crlUrl = certAtt.getValue();
            if (brokenCrlUrlList.contains(crlUrl)) {
                this.LOG.debug("CRL URL'{}' already marked as broken / inaccessable", (Object)crlUrl);
                continue;
            }
            info.incUrlCount();
            try {
                this.LOG.debug("downloading CRL '{}'", (Object)crlUrl);
                X509CRL crl = this.crlUtil.downloadCRL(crlUrl);
                if (crl == null) {
                    this.LOG.debug("downloaded CRL == null ");
                    continue;
                }
                long nextUpdate = crl.getNextUpdate().getTime();
                if (nextUpdate > maxNextUpdate) {
                    this.LOG.debug("nextUpdate {} from CRL limited to {}", (Object)crl.getNextUpdate(), (Object)new Date(maxNextUpdate));
                    nextUpdate = maxNextUpdate;
                }
                this.certUtil.setCertAttribute(cert, "CRL_NEXT_UPDATE", Long.toString(nextUpdate), false);
                X509CRLEntry crlItem = crl.getRevokedCertificate(new BigInteger(cert.getSerial()));
                if (crlItem != null && crl.isRevoked(x509Cert)) {
                    String revocationReason = "unspecified";
                    if (crlItem.getRevocationReason() != null && this.cryptoUtil.crlReasonAsString(CRLReason.lookup((int)crlItem.getRevocationReason().ordinal())) != null) {
                        revocationReason = this.cryptoUtil.crlReasonAsString(CRLReason.lookup((int)crlItem.getRevocationReason().ordinal()));
                    }
                    Date revocationDate = new Date();
                    if (crlItem.getRevocationDate() != null) {
                        revocationDate = crlItem.getRevocationDate();
                    } else {
                        this.LOG.debug("Checking certificate {}: no RevocationDate present for reason {}!", (Object)cert.getId(), (Object)revocationReason);
                    }
                    this.certUtil.setRevocationStatus(cert, revocationReason, revocationDate);
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("CERTIFICATE_REVOKED_BY_CRL", cert));
                }
                info.setSuccess();
                break;
            }
            catch (IOException | CRLException | CertificateException | NamingException e2) {
                this.LOG.info("Problem retrieving CRL for certificate " + cert.getId(), (Throwable)e2);
                brokenCrlUrlList.add(crlUrl);
            }
        }
        return info;
    }

    @Scheduled(cron="0 15 2 * * ?")
    public int notifyRAOfficerHolderOnExpiry() {
        try {
            return this.notificationService.notifyRAOfficerHolderOnExpiry();
        }
        catch (MessagingException e) {
            this.LOG.info("Problem sending notification email", (Throwable)e);
            return 0;
        }
    }
}

