/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CSRSpecifications;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateSelectionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class CSRViewRepository {
    private final EntityManager entityManager;
    private final CertificateSelectionUtil certificateSelectionAttributeList;
    private final CSRRepository csrRepository;
    private final CSRUtil csrUtil;

    public CSRViewRepository(EntityManager entityManager, CertificateSelectionUtil certificateSelectionAttributeList, CSRRepository csrRepository, CSRUtil csrUtil) {
        this.entityManager = entityManager;
        this.certificateSelectionAttributeList = certificateSelectionAttributeList;
        this.csrRepository = csrRepository;
        this.csrUtil = csrUtil;
    }

    public Page<CSRView> findSelection(Map<String, String[]> parameterMap) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        return CSRSpecifications.handleQueryParamsCertificateView((EntityManager)this.entityManager, (CriteriaBuilder)cb, parameterMap, (List)this.certificateSelectionAttributeList.getCertificateSelectionAttributes());
    }

    public Optional<CSRView> findbyCSRId(Long csrId) {
        Optional optCSR = this.csrRepository.findById((Object)csrId);
        if (optCSR.isPresent()) {
            return Optional.of(new CSRView(this.csrUtil, (CSR)optCSR.get()));
        }
        return Optional.empty();
    }
}

