/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import io.github.jhipster.config.liquibase.AsyncSpringLiquibase;
import io.github.jhipster.config.liquibase.SpringLiquibaseUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Configuration
public class LiquibaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(LiquibaseConfiguration.class);
    private final Environment env;
    @Value(value="${spring.liquibase.changeLog:classpath:config/liquibase/master.xml}")
    private String certificateImportActive;

    public LiquibaseConfiguration(Environment env) {
        this.env = env;
    }

    @Bean
    public SpringLiquibase liquibase(@Qualifier(value="taskExecutor") Executor executor, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource, LiquibaseProperties liquibaseProperties, ObjectProvider<DataSource> dataSource, DataSourceProperties dataSourceProperties) {
        AsyncSpringLiquibase liquibase = SpringLiquibaseUtil.createAsyncSpringLiquibase((Environment)this.env, (Executor)executor, (DataSource)((DataSource)liquibaseDataSource.getIfAvailable()), (LiquibaseProperties)liquibaseProperties, (DataSource)((DataSource)dataSource.getIfUnique()), (DataSourceProperties)dataSourceProperties);
        this.log.debug("Using liquibase files from '{}'", (Object)this.certificateImportActive);
        liquibase.setChangeLog(this.certificateImportActive);
        liquibase.setContexts(liquibaseProperties.getContexts());
        liquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        try {
            Method method = liquibase.getClass().getMethod("setLiquibaseSchema", String.class);
            method.invoke((Object)liquibase, liquibaseProperties.getLiquibaseSchema());
            method = liquibase.getClass().getMethod("setLiquibaseTablespace", String.class);
            method.invoke((Object)liquibase, liquibaseProperties.getLiquibaseTablespace());
            method = liquibase.getClass().getMethod("setDatabaseChangeLogLockTable", String.class);
            method.invoke((Object)liquibase, liquibaseProperties.getDatabaseChangeLogLockTable());
            method = liquibase.getClass().getMethod("setDatabaseChangeLogTable", String.class);
            method.invoke((Object)liquibase, liquibaseProperties.getDatabaseChangeLogTable());
            method = liquibase.getClass().getMethod("setTestRollbackOnUpdate", Boolean.class);
            method.invoke((Object)liquibase, liquibaseProperties.isTestRollbackOnUpdate());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.debug("Old Liquibase version, not supporting more recent methods");
        }
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        liquibase.setLabels(liquibaseProperties.getLabels());
        liquibase.setChangeLogParameters(liquibaseProperties.getParameters());
        liquibase.setRollbackFile(liquibaseProperties.getRollbackFile());
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"no-liquibase"}))) {
            liquibase.setShouldRun(false);
        } else {
            liquibase.setShouldRun(liquibaseProperties.isEnabled());
            this.log.debug("Configuring Liquibase");
        }
        return liquibase;
    }
}

