/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import de.trustable.ca3s.core.EndpointConfigs;
import de.trustable.ca3s.core.config.ApplicationProperties;
import de.trustable.ca3s.core.config.DefaultProfileUtil;
import de.trustable.ca3s.core.security.provider.Ca3sFallbackBundleFactory;
import de.trustable.ca3s.core.security.provider.Ca3sKeyManagerProvider;
import de.trustable.ca3s.core.security.provider.Ca3sKeyStoreProvider;
import de.trustable.ca3s.core.security.provider.TimedRenewalCertMapHolder;
import de.trustable.util.JCAManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableConfigurationProperties(value={LiquibaseProperties.class, ApplicationProperties.class})
public class Ca3SApp
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Ca3SApp.class);
    public static final String SERVER_TLS_PREFIX = "ca3s.tlsAccess.";
    public static final String SERVER_ADMIN_PREFIX = "ca3s.adminAccess.";
    public static final String SERVER_RA_PREFIX = "ca3s.raAccess.";
    public static final String SERVER_ACME_PREFIX = "ca3s.acmeAccess.";
    public static final String SERVER_SCEP_PREFIX = "ca3s.scepAccess.";
    public static final String DEFAULT_BINDING_HOST = "0.0.0.0";
    public static final String HTTPS_CERTIFICATE_DN_SUFFIX = "ca3s.https.certificate.dnSuffix";
    public static final String O_TRUSTABLE_SOLUTIONS_C_DE = "O=trustable solutions, C=DE";
    private final Environment env;

    public Ca3SApp(Environment env) {
        this.env = env;
    }

    public void afterPropertiesSet() throws Exception {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("dev") && activeProfiles.contains("prod")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'prod' profiles at the same time.");
        }
        if (activeProfiles.contains("dev") && activeProfiles.contains("cloud")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'cloud' profiles at the same time.");
        }
    }

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{Ca3SApp.class});
        DefaultProfileUtil.addDefaultProfile((SpringApplication)app);
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        Ca3SApp.logApplicationStartup((Environment)env);
    }

    private static void logApplicationStartup(Environment env) {
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        String serverPort = env.getProperty("server.port");
        String contextPath = env.getProperty("server.servlet.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = "/";
        }
        String hostAddress = "localhost";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("The host name could not be determined, using `localhost` as fallback");
        }
        log.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}{}\n\tExternal: \t{}://{}:{}{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, serverPort, contextPath, protocol, hostAddress, serverPort, contextPath, env.getActiveProfiles()});
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer placeholderConfigurer() {
        PropertySourcesPlaceholderConfigurer propsConfig = new PropertySourcesPlaceholderConfigurer();
        propsConfig.setLocation((Resource)new ClassPathResource("git.properties"));
        propsConfig.setIgnoreResourceNotFound(true);
        propsConfig.setIgnoreUnresolvablePlaceholders(true);
        return propsConfig;
    }

    @Bean
    public TimedRenewalCertMapHolder registerJCEProvider() {
        JCAManager.getInstance();
        String dnSuffix = this.env.getProperty("ca3s.https.certificate.dnSuffix", "O=trustable solutions, C=DE");
        TimedRenewalCertMap certMap = new TimedRenewalCertMap(null, (BundleFactory)new Ca3sFallbackBundleFactory(dnSuffix));
        Security.addProvider((Provider)new Ca3sKeyStoreProvider(certMap, "ca3s"));
        Security.addProvider((Provider)new Ca3sKeyManagerProvider(certMap));
        TimedRenewalCertMapHolder trcmh = new TimedRenewalCertMapHolder();
        trcmh.setCertMap(certMap);
        log.info("JCAManager and Provider initialized ...");
        return trcmh;
    }

    @Bean
    public UndertowServletWebServerFactory embeddedServletContainerFactory() {
        this.registerJCEProvider();
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        EndpointConfigs endpointConfigs = this.getEndpointConfigs();
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new /* Unavailable Anonymous Inner Class!! */});
        return factory;
    }

    EndpointConfigs getEndpointConfigs() {
        EndpointConfigs epc = new EndpointConfigs();
        epc.addConfig(this.getPortForUsage("ca3s.tlsAccess.", 8442), this.getHTTPSForUsage("ca3s.tlsAccess.", true), this.getBindingHostForUsage("ca3s.tlsAccess.", "0.0.0.0"), "TLS Port");
        epc.addConfig(this.getPortForUsage("ca3s.adminAccess.", 8442), this.getHTTPSForUsage("ca3s.adminAccess.", true), this.getBindingHostForUsage("ca3s.adminAccess.", "0.0.0.0"), "Admin Port");
        epc.addConfig(this.getPortForUsage("ca3s.raAccess.", 8442), this.getHTTPSForUsage("ca3s.raAccess.", true), this.getBindingHostForUsage("ca3s.raAccess.", "0.0.0.0"), "RA Port");
        epc.addConfig(this.getPortForUsage("ca3s.acmeAccess.", 8442), this.getHTTPSForUsage("ca3s.acmeAccess.", true), this.getBindingHostForUsage("ca3s.acmeAccess.", "0.0.0.0"), "ACME Port");
        int httpPort = this.getPortForUsage("server.port", 8080);
        int scepPort = this.getPortForUsage("ca3s.scepAccess.", 8081);
        if (scepPort != httpPort) {
            epc.addConfig(scepPort, this.getHTTPSForUsage("ca3s.scepAccess.", false), this.getBindingHostForUsage("ca3s.scepAccess.", "0.0.0.0"), "SCEP Port");
        }
        return epc;
    }

    int getPortForUsage(String usage, int defaultPort) {
        int port = defaultPort;
        String envPort = this.env.getProperty(usage + "port");
        if (envPort == null) {
            log.debug("Port for usage '{}' undefined, using default port #{}", (Object)usage, (Object)defaultPort);
        } else {
            port = Integer.parseUnsignedInt(envPort);
        }
        return port;
    }

    boolean getHTTPSForUsage(String usage, boolean defaultHTTPS) {
        boolean isHttps = defaultHTTPS;
        String envPort = this.env.getProperty(usage + "https");
        if (envPort == null) {
            log.debug("Use HTTPS for usage '{}' undefined, using default mode {}", (Object)usage, (Object)defaultHTTPS);
        } else {
            isHttps = Boolean.parseBoolean(envPort);
        }
        return isHttps;
    }

    String getBindingHostForUsage(String usage, String defaultBindingHost) {
        String bindingHost = defaultBindingHost;
        String envPort = this.env.getProperty(usage + "bindingHost");
        if (envPort == null) {
            log.debug("Binding host for usage '{}' undefined, using default '{}'", (Object)usage, (Object)defaultBindingHost);
        } else {
            bindingHost = envPort;
        }
        return bindingHost;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

