/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.ca3s.core.web.rest.data.NamedValues;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateHolderShallow {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertificateHolderShallow.class);
    private long certificateId;
    private String subject;
    private String issuer;
    private String type;
    private String fingerprint;
    private String serial;
    private LocalDateTime validFrom;
    private LocalDateTime validTo;
    private NamedValues[] subjectParts;
    @JsonProperty(value="sans")
    private String[] sans;
    private String[] extensions;
    private boolean keyPresent = false;
    private boolean certificatePresentInDB = false;
    private boolean publicKeyPresentInDB = false;
    private String pemCertificate;

    public X509CertificateHolderShallow(X509CertificateHolder holder) {
        int i;
        this.subject = holder.getSubject().toString();
        HashMap rdnMap = new HashMap();
        try {
            ASN1ObjectIdentifier[] name;
            List<Rdn> rdnList = new LdapName(this.subject).getRdns();
            for (Rdn rdn : rdnList) {
                List<String> nameList;
                name = rdn.getType();
                if (!rdnMap.containsKey(name)) {
                    nameList = new ArrayList();
                    rdnMap.put(name, nameList);
                }
                nameList = (List)rdnMap.get(name);
                nameList.add(rdn.getValue().toString());
            }
            this.subjectParts = new NamedValues[rdnMap.size()];
            Iterator it = rdnMap.keySet().iterator();
            for (i = 0; i < rdnMap.size(); ++i) {
                NamedValues nvs;
                name = (String)it.next();
                List valueList = (List)rdnMap.get(name);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                this.subjectParts[i] = nvs = new NamedValues((String)name, values);
            }
        }
        catch (InvalidNameException e1) {
            LOG.info("problem parsing subject '{}', : {}", (Object)this.subject, (Object)e1.getLocalizedMessage());
        }
        this.issuer = holder.getIssuer().toString();
        this.type = "V" + holder.getVersionNumber();
        try {
            this.fingerprint = Base64.toBase64String((byte[])CryptoUtil.generateSHA1Fingerprint((byte[])holder.getEncoded()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.serial = holder.getSerialNumber().toString();
        this.validFrom = DateUtil.asLocalDateTimeUTC((Date)holder.getNotBefore());
        this.validTo = DateUtil.asLocalDateTimeUTC((Date)holder.getNotAfter());
        int nExtensions = 0;
        Extensions exts = holder.getExtensions();
        if (exts != null && exts.getExtensionOIDs() != null) {
            nExtensions = exts.getExtensionOIDs().length;
        }
        this.extensions = new String[nExtensions];
        this.sans = new String[0];
        if (nExtensions > 0) {
            i = 0;
            for (ASN1ObjectIdentifier objId : exts.getExtensionOIDs()) {
                this.extensions[i++] = OidNameMapper.lookupOid((String)objId.getId());
            }
            GeneralNames namesSAN = GeneralNames.fromExtensions((Extensions)exts, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
            if (namesSAN != null && namesSAN.getNames() != null) {
                int j = 0;
                this.sans = new String[namesSAN.getNames().length];
                for (GeneralName gn : namesSAN.getNames()) {
                    this.sans[j++] = CSRUtil.getGeneralNameDescription((GeneralName)gn);
                }
            }
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(LocalDateTime validTo) {
        this.validTo = validTo;
    }

    public String[] getSans() {
        return this.sans;
    }

    public void setSans(String[] sans) {
        this.sans = sans;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public boolean isKeyPresent() {
        return this.keyPresent;
    }

    public void setKeyPresent(boolean keyPresent) {
        this.keyPresent = keyPresent;
    }

    public String getPemCertrificate() {
        return this.pemCertificate;
    }

    public void setPemCertificate(String pemCertificate) {
        this.pemCertificate = pemCertificate;
    }

    public boolean isCertificatePresentInDB() {
        return this.certificatePresentInDB;
    }

    public void setCertificatePresentInDB(boolean presentInDB) {
        this.certificatePresentInDB = presentInDB;
    }

    public boolean isPublicKeyPresentInDB() {
        return this.publicKeyPresentInDB;
    }

    public void setPublicKeyPresentInDB(boolean publicKeyPresentInDB) {
        this.publicKeyPresentInDB = publicKeyPresentInDB;
    }

    public long getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(long certificateId) {
        this.certificateId = certificateId;
    }

    public NamedValues[] getSubjectParts() {
        return this.subjectParts;
    }

    public void setSubjectParts(NamedValues[] subjectParts) {
        this.subjectParts = subjectParts;
    }
}

