/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.RDN;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.ARARestriction;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.data.NamedValues;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CertificateProcessingUtil {
    private final Logger LOG = LoggerFactory.getLogger(CertificateProcessingUtil.class);
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CSRUtil csrUtil;
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private CsrAttributeRepository csrAttRepository;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private BPMNUtil bpmnUtil;
    @Autowired
    private PipelineUtil pvUtil;
    @Autowired
    private AuditService auditService;

    public Certificate processCertificateRequest(String csrAsPem, String requestorName, String requestAuditType, String certificateAuditType, String requestorComment, Pipeline pipeline) {
        CSR csr = this.buildCSR(csrAsPem, requestorName, requestAuditType, requestorComment, pipeline);
        if (csr == null) {
            this.LOG.info("building CSR failed");
        }
        return this.processCertificateRequest(csr, requestorName, certificateAuditType, pipeline);
    }

    public CSR buildCSR(String csrAsPem, String requestorName, String requestAuditType, String requestorComment, Pipeline pipeline) {
        ArrayList messageList = new ArrayList();
        NamedValues[] nvArr = new NamedValues[]{};
        return this.buildCSR(csrAsPem, requestorName, requestAuditType, requestorComment, pipeline, nvArr, messageList);
    }

    public CSR buildCSR(String csrAsPem, String requestorName, String requestAuditType, String requestorComment, Pipeline pipeline, NamedValues[] araArr, List<String> messageList) {
        CSR csr;
        Pkcs10RequestHolder p10ReqHolder;
        try {
            p10ReqHolder = this.cryptoUtil.parseCertificateRequest(csrAsPem);
            ARARestriction[] restrictionArr = new ARARestriction[]{};
            if (pipeline == null) {
                this.LOG.debug("CSR requested without pipeline given!", (Throwable)new Exception());
                csr = this.csrUtil.buildCSR(csrAsPem, requestorName, p10ReqHolder, PipelineType.WEB, null);
            } else {
                csr = this.csrUtil.buildCSR(csrAsPem, requestorName, p10ReqHolder, pipeline);
                NamedValues[] pv = this.pvUtil.from(pipeline);
                restrictionArr = pv.getAraRestrictions();
            }
            csr.setRequestorComment(requestorComment);
            this.csrRepository.save((Object)csr);
            for (NamedValues nvs : araArr) {
                if (Arrays.stream(restrictionArr).anyMatch(r -> r.getName().equals(nvs.getName()))) {
                    for (String value : nvs.getValues()) {
                        CsrAttribute csrAttr = new CsrAttribute();
                        csrAttr.setCsr(csr);
                        csrAttr.setName("_ARA_" + nvs.getName());
                        csrAttr.setValue(value);
                        csr.getCsrAttributes().add(csrAttr);
                    }
                    continue;
                }
                this.LOG.warn("unexpected attribute in ar array: '{}'", (Object)nvs.getName());
            }
            this.csrAttRepository.saveAll((Iterable)csr.getCsrAttributes());
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceRequest(requestAuditType, csr));
            this.LOG.debug("csr contains #{} CsrAttributes, #{} RequestAttributes and #{} RDN", new Object[]{csr.getCsrAttributes().size(), csr.getRas().size(), csr.getRdns().size()});
            for (RDN rdn : csr.getRdns()) {
                this.LOG.debug("RDN contains #{}", (Object)rdn.getRdnAttributes().size());
            }
        }
        catch (IOException | GeneralSecurityException e) {
            this.LOG.warn("problem building a CSR for requestor '" + requestorName + "'failed", (Throwable)e);
            return null;
        }
        if (this.pvUtil.isPipelineRestrictionsResolved(pipeline, p10ReqHolder, araArr, messageList)) {
            return csr;
        }
        String msg = "certificate request " + csr.getId() + " rejected";
        if (!messageList.isEmpty()) {
            msg = msg + ", validation of restriction failed: '" + messageList.get(0) + "'";
        }
        if (messageList.size() > 1) {
            msg = msg + ", " + (messageList.size() - 1) + " more failures.";
        }
        this.LOG.info("Restrictions failed {}", (Object)msg);
        HashMap<String, String> messageMap = new HashMap<String, String>();
        for (String msgItem : messageList) {
            messageMap.put("RequestRestriction", CryptoUtil.limitLength((String)msgItem, (int)250));
        }
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRestrictionFailed(csr));
        return null;
    }

    public Certificate processCertificateRequest(CSR csr, String requestorName, String certificateAuditType, Pipeline pipeline) {
        if (csr == null) {
            this.LOG.warn("creation of certificate requires a csr!");
            return null;
        }
        boolean bApprovalRequired = false;
        if (pipeline != null) {
            bApprovalRequired = pipeline.isApprovalRequired();
        }
        if (bApprovalRequired) {
            this.LOG.debug("defering certificate creation for csr #{}", (Object)csr.getId());
        } else {
            Certificate cert = this.bpmnUtil.startCertificateCreationProcess(csr);
            if (cert != null) {
                this.certificateRepository.save((Object)cert);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate(certificateAuditType, cert));
                return cert;
            }
            this.LOG.warn("creation of certificate requested by {} failed ", (Object)requestorName);
        }
        return null;
    }
}

