/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.web.servlet.ScepServletImpl;
import de.trustable.util.CryptoUtil;
import de.trustable.util.PKILevel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaInternalConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ScepServletImpl.class);
    @Autowired
    CertificateRepository certRepository;
    @Autowired
    CSRRepository csrRepository;
    @Autowired
    CryptoUtil cryptoUtil;
    @Autowired
    CertificateUtil certUtil;
    @Autowired
    CSRUtil csrUtil;

    Certificate getRoot() throws GeneralSecurityException, IOException {
        List certList = this.certRepository.findByAttributeValue("CA3S:ROOT", "true");
        Certificate certRoot = this.getLongestValidCertificate(certList);
        if (certRoot == null) {
            certRoot = this.createNewRoot();
        }
        return certRoot;
    }

    Certificate getIntermediate() throws GeneralSecurityException, IOException {
        List certList = this.certRepository.findByAttributeValue("CA3S:INTERMEDIATE", "true");
        Certificate certIntermediate = this.getLongestValidCertificate(certList);
        if (certIntermediate == null) {
            certIntermediate = this.createNewIntermediate(this.getRoot());
        }
        return certIntermediate;
    }

    private Certificate createNewIntermediate(Certificate root) throws GeneralSecurityException, IOException {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        X500Name subject = new X500Name("CN=CA3S-Intermediate" + System.currentTimeMillis() + ", OU=Internal Only, OU=Dev/Test Only, O=trustable solutions, C=DE");
        PrivateKey privKeyRoot = this.certUtil.getPrivateKey(root);
        KeyPair kpRoot = new KeyPair(this.certUtil.convertPemToCertificate(root.getContent()).getPublicKey(), privKeyRoot);
        X509Certificate x509Cert = this.cryptoUtil.issueCertificate(new X500Name(root.getSubject()), kpRoot, subject, keyPair.getPublic().getEncoded(), 1, 1, PKILevel.INTERMEDIATE);
        Certificate intermediateCert = this.certUtil.createCertificate(x509Cert.getEncoded(), null, "", false);
        this.certUtil.storePrivateKey(intermediateCert, keyPair);
        this.certUtil.setCertAttribute(intermediateCert, "CA3S:INTERMEDIATE", "true");
        this.certRepository.save((Object)intermediateCert);
        return intermediateCert;
    }

    private Certificate createNewRoot() throws GeneralSecurityException, IOException {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        X500Name subject = new X500Name("CN=CA3S-InternalRoot" + System.currentTimeMillis() + ", OU=Internal Only, OU=Dev/Test Only, O=trustable solutions, C=DE");
        X509Certificate x509Cert = this.cryptoUtil.issueCertificate(subject, keyPair, subject, keyPair.getPublic().getEncoded(), 1, 1, PKILevel.ROOT);
        Certificate rootCert = this.certUtil.createCertificate(x509Cert.getEncoded(), null, "", false);
        this.certUtil.storePrivateKey(rootCert, keyPair);
        this.certUtil.setCertAttribute(rootCert, "CA3S:ROOT", "true");
        this.certRepository.save((Object)rootCert);
        return rootCert;
    }

    private Certificate getLongestValidCertificate(List<Certificate> certList) {
        Instant now = Instant.now();
        Certificate certLongestValid = null;
        for (Certificate cert : certList) {
            if (!now.isAfter(cert.getValidFrom()) || !now.isBefore(cert.getValidTo())) continue;
            if (certLongestValid == null) {
                certLongestValid = cert;
                continue;
            }
            if (!certLongestValid.getValidTo().isBefore(cert.getValidTo())) continue;
            certLongestValid = cert;
        }
        return certLongestValid;
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConfig) throws GeneralSecurityException {
        try {
            Attribute[] certAttributes;
            this.csrUtil.setCsrAttribute(csr, "CA_PROCESSING_STARTED_TIMESTAMP", "" + System.currentTimeMillis(), false);
            csr.setStatus(CsrStatus.PROCESSING);
            Certificate intermediate = this.getIntermediate();
            PrivateKey privKeyIntermediate = this.certUtil.getPrivateKey(intermediate);
            KeyPair kpIntermediate = new KeyPair(this.certUtil.convertPemToCertificate(intermediate.getContent()).getPublicKey(), privKeyIntermediate);
            PKCS10CertificationRequest p10 = this.cryptoUtil.convertPemToPKCS10CertificationRequest(csr.getCsrBase64());
            GeneralNames gns = null;
            for (Attribute attribute : certAttributes = p10.getAttributes()) {
                if (!attribute.getAttrType().equals((ASN1Primitive)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
                Extensions extensions = Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
                gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
            }
            X509Certificate x509Cert = this.cryptoUtil.issueCertificate(new X500Name(intermediate.getSubject()), kpIntermediate, p10.getSubject(), p10.getSubjectPublicKeyInfo(), 1, 1, gns, PKILevel.END_ENTITY);
            Certificate cert = this.certUtil.createCertificate(x509Cert.getEncoded(), csr, "", false);
            cert.setRevocationCA(caConfig);
            this.certRepository.save((Object)cert);
            this.csrUtil.setCsrAttribute(csr, "CA_PROCESSING_FINISHED_TIMESTAMP", "" + System.currentTimeMillis(), true);
            csr.setStatus(CsrStatus.ISSUED);
            this.csrRepository.save((Object)csr);
            return cert;
        }
        catch (IOException e) {
            LOG.info("Problem signing certificate request", (Throwable)e);
            throw new GeneralSecurityException(e);
        }
    }

    public void revokeCertificate(Certificate cert, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConfig) {
        if (cert.isRevoked().booleanValue()) {
            LOG.warn("failureReason: certificate with id '" + cert.getId() + "' already revoked.");
        }
        String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
        LOG.debug("crlReason : " + crlReasonStr);
        cert.setActive(Boolean.valueOf(false));
        cert.setRevoked(Boolean.valueOf(true));
        cert.setRevokedSince(Instant.now());
        cert.setRevocationReason(crlReasonStr);
        this.certRepository.save((Object)cert);
    }
}

