/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditTraceService;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditTraceServiceImpl
implements AuditTraceService {
    private final Logger log = LoggerFactory.getLogger(AuditTraceServiceImpl.class);
    private final AuditTraceRepository auditTraceRepository;
    private final CertificateRepository certificateRepository;
    private final CSRRepository csrRepository;
    private final PipelineRepository pipelineRepository;
    private final CAConnectorConfigRepository caConnectorConfigRepository;
    private final BPMNProcessInfoRepository bpmnProcessInfoRepository;

    public AuditTraceServiceImpl(AuditTraceRepository auditTraceRepository, CertificateRepository certificateRepository, CSRRepository csrRepository, PipelineRepository pipelineRepository, CAConnectorConfigRepository caConnectorConfigRepository, BPMNProcessInfoRepository bpmnProcessInfoRepository) {
        this.auditTraceRepository = auditTraceRepository;
        this.certificateRepository = certificateRepository;
        this.csrRepository = csrRepository;
        this.pipelineRepository = pipelineRepository;
        this.caConnectorConfigRepository = caConnectorConfigRepository;
        this.bpmnProcessInfoRepository = bpmnProcessInfoRepository;
    }

    public AuditTrace save(AuditTrace auditTrace) {
        this.log.debug("Request to save AuditTrace : {}", (Object)auditTrace);
        return (AuditTrace)this.auditTraceRepository.save((Object)auditTrace);
    }

    @Transactional(readOnly=true)
    public Page<AuditTrace> findAll(Pageable pageable) {
        this.log.debug("Request to get all AuditTraces");
        return this.auditTraceRepository.findAll(pageable);
    }

    @Transactional(readOnly=true)
    public Optional<AuditTrace> findOne(Long id) {
        this.log.debug("Request to get AuditTrace : {}", (Object)id);
        return this.auditTraceRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AuditTrace : {}", (Object)id);
        this.auditTraceRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public Page<AuditTrace> findBy(Pageable pageable, Long certificateId, Long csrId, Long pipelineId, Long caConnectorId, Long processInfoId) {
        if (certificateId != null || csrId != null) {
            Optional optCsr;
            Optional optCert;
            this.log.debug("Request to select AuditTrace by certificate id '{}' or csr id '{}'", (Object)certificateId, (Object)csrId);
            Certificate cert = null;
            CSR csr = null;
            if (certificateId != null && (optCert = this.certificateRepository.findById((Object)certificateId)).isPresent()) {
                cert = (Certificate)optCert.get();
            }
            if (csrId != null && (optCsr = this.csrRepository.findById((Object)csrId)).isPresent()) {
                csr = (CSR)optCsr.get();
            }
            return this.auditTraceRepository.findByCsrAndCert(pageable, cert, csr);
        }
        if (pipelineId != null) {
            this.log.debug("Request to select AuditTrace by pipeline id '{}'", (Object)pipelineId);
            Optional optPipeline = this.pipelineRepository.findById((Object)pipelineId);
            if (optPipeline.isPresent()) {
                return this.auditTraceRepository.findByPipeline(pageable, (Pipeline)optPipeline.get());
            }
        } else if (caConnectorId != null) {
            this.log.debug("Request to select AuditTrace by caConnector id '{}'", (Object)caConnectorId);
            Optional optCaConfig = this.caConnectorConfigRepository.findById((Object)caConnectorId);
            if (optCaConfig.isPresent()) {
                return this.auditTraceRepository.findByCaConnector(pageable, (CAConnectorConfig)optCaConfig.get());
            }
        } else if (processInfoId != null) {
            this.log.debug("Request to select AuditTrace by processInfo id '{}'", (Object)processInfoId);
            Optional optProcessInfo = this.bpmnProcessInfoRepository.findById((Object)processInfoId);
            if (optProcessInfo.isPresent()) {
                return this.auditTraceRepository.findByProcessInfo(pageable, (BPMNProcessInfo)optProcessInfo.get());
            }
        } else {
            this.log.warn("Request to select AuditTrace : non-null argument required!");
        }
        return new PageImpl(new ArrayList());
    }
}

