/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.util.DateUtil;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SpecificationsHelper {
    static Logger logger = LoggerFactory.getLogger(SpecificationsHelper.class);
    static final String SORT = "sort";
    static final String ORDER = "order";

    private SpecificationsHelper() {
    }

    private static String getContainsLikePattern(String searchTerm) {
        if (searchTerm == null || searchTerm.isEmpty()) {
            return "%";
        }
        return searchTerm.toLowerCase() + "%";
    }

    public static String getStringValue(String[] inArr) {
        return SpecificationsHelper.getStringValue((String[])inArr, (String)"");
    }

    public static String getStringValue(String[] inArr, String defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return inArr[0];
    }

    public static int getIntValue(String[] inArr, int defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return Integer.parseInt(inArr[0]);
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (parameterMap.containsKey(paramNameAttribute)) {
                String attribute = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttribute));
                if (attribute.length() == 0) {
                    logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                    continue;
                }
                String paramNameAttributeSelector = "attributeSelector_" + n;
                String attributeSelector = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
                if (attributeSelector.length() == 0) {
                    logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                    continue;
                }
                String paramNameAttributeValue = "attributeValue_" + n;
                String attributeValue = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
                if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                    logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                    continue;
                }
                logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
                SelectionData selData = new SelectionData(attributeSelector, attributeValue);
                if (selectorMap.containsKey(attribute)) {
                    logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                    ((List)selectorMap.get(attribute)).add(selData);
                    continue;
                }
                logger.debug("creating new selector list for '{}'", (Object)attribute);
                ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
                selectorList.add(selData);
                selectorMap.put(attribute, selectorList);
                continue;
            }
            logger.debug("paramNameAttribute '{}' not contained in parameterMap ", (Object)paramNameAttribute);
            break;
        }
        return selectorMap;
    }

    static void addNewColumn(List<Selection<?>> selectionList, Selection<?> sel) {
        if (!selectionList.contains(sel)) {
            selectionList.add(sel);
        }
    }

    static Predicate buildPredicateString(String attributeSelector, CriteriaBuilder cb, Expression<String> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.equal(expression, (Object)value);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate not equal ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.notEqual(expression, (Object)value);
        }
        if (Selector.ON.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate on ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.equal(expression, (Object)value);
        }
        if (Selector.LIKE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate like ('{}') for value '{}'", (Object)attributeSelector, (Object)SpecificationsHelper.getContainsLikePattern((String)value));
            return cb.like(expression, SpecificationsHelper.getContainsLikePattern((String)value));
        }
        if (Selector.NOTLIKE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate not like ('{}') for value '{}'", (Object)attributeSelector, (Object)SpecificationsHelper.getContainsLikePattern((String)value));
            return cb.like(expression, SpecificationsHelper.getContainsLikePattern((String)value)).not();
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.lessThan(expression, (Comparable)((Object)value));
        }
        if (Selector.BEFORE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate before ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.lessThan(expression, (Comparable)((Object)value));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.greaterThan(expression, (Comparable)((Object)value));
        }
        if (Selector.AFTER.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate after ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.greaterThan(expression, (Comparable)((Object)value));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
        return cb.equal(expression, (Object)value);
    }

    static Predicate buildPredicateLong(String attributeSelector, CriteriaBuilder cb, Expression<Long> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        long lValue = Long.parseLong(value.trim());
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.equal(expression, (Object)lValue);
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.lessThan(expression, (Comparable)Long.valueOf(lValue));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.greaterThan(expression, (Comparable)Long.valueOf(lValue));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
        return cb.equal(expression, (Object)lValue);
    }

    static Predicate buildPredicateInteger(String attributeSelector, CriteriaBuilder cb, Expression<Integer> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        int lValue = Integer.parseInt(value.trim());
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.equal(expression, (Object)lValue);
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.lessThan(expression, (Comparable)Integer.valueOf(lValue));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.greaterThan(expression, (Comparable)Integer.valueOf(lValue));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
        return cb.equal(expression, (Object)lValue);
    }

    static Predicate buildBooleanPredicate(String attributeSelector, CriteriaBuilder cb, Expression<Boolean> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        logger.debug("buildBooleanPredicatedefaults to equals ('{}') ", (Object)attributeSelector);
        if (Selector.ISTRUE.toString().equals(attributeSelector)) {
            return cb.equal(expression, (Object)Boolean.TRUE);
        }
        return cb.equal(expression, (Object)Boolean.FALSE);
    }

    private static Predicate buildDatePredicate(String attributeSelector, CriteriaBuilder cb, Expression<Instant> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        try {
            Instant dateTime;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateTime = DateUtil.asInstant((Date)dateFormat.parse(value));
            }
            catch (Exception ex) {
                dateTime = Instant.ofEpochMilli(Long.parseLong(value));
            }
            if (Selector.ON.toString().equals(attributeSelector)) {
                Instant dateTimeStart = dateTime.plus(1L, ChronoUnit.HOURS).truncatedTo(ChronoUnit.DAYS);
                Instant dateTimeEnd = dateTimeStart.plus(1L, ChronoUnit.DAYS);
                logger.debug("buildDatePredicate on ('{}') for value > {} and < {}", new Object[]{attributeSelector, dateTimeStart, dateTimeEnd});
                return cb.and((Expression)cb.lessThanOrEqualTo(expression, (Comparable)dateTimeEnd), (Expression)cb.greaterThanOrEqualTo(expression, (Comparable)dateTimeStart));
            }
            if (Selector.BEFORE.toString().equals(attributeSelector)) {
                logger.debug("buildDatePredicate before ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
                return cb.lessThanOrEqualTo(expression, (Comparable)dateTime);
            }
            if (Selector.AFTER.toString().equals(attributeSelector)) {
                logger.debug("buildDatePredicate after ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
                return cb.greaterThanOrEqualTo(expression, (Comparable)dateTime);
            }
            logger.debug("buildDatePredicate defaults to equals ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
            return cb.equal(expression, (Object)dateTime);
        }
        catch (Exception ex) {
            logger.debug("parsing date ... ", (Throwable)ex);
            return cb.conjunction();
        }
    }
}

