/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.CSR_;
import de.trustable.ca3s.core.domain.Certificate_;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.CsrAttribute_;
import de.trustable.ca3s.core.domain.Pipeline_;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.util.DateUtil;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CSRSpecifications {
    static Logger logger = LoggerFactory.getLogger(CSRSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";

    private CSRSpecifications() {
    }

    private static String getContainsLikePattern(String searchTerm) {
        if (searchTerm == null || searchTerm.isEmpty()) {
            return "%";
        }
        return searchTerm.toLowerCase() + "%";
    }

    public static String getStringValue(String[] inArr) {
        return CSRSpecifications.getStringValue((String[])inArr, (String)"");
    }

    public static String getStringValue(String[] inArr, String defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return inArr[0];
    }

    public static int getIntValue(String[] inArr, int defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return Integer.parseInt(inArr[0]);
    }

    public static Page<CSRView> handleQueryParamsCertificateView(EntityManager entityManager, CriteriaBuilder cb, Map<String, String[]> parameterMap) {
        String[] paramArr;
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(CSR.class);
        String sortCol = CSRSpecifications.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = CSRSpecifications.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = CSRSpecifications.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = CSRSpecifications.getIntValue((String[])parameterMap.get("limit"), (int)20);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = CSRSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = new String[]{};
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(CSRSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(CSRSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        List listResponse = typedQuery.getResultList();
        ArrayList<CSRView> certViewList = new ArrayList<CSRView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            CSRView cv = CSRSpecifications.buildCSRViewFromObjArr(colList, (Object[])objArr);
            certViewList.add(cv);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        Long nTotalElements = 1000L;
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(CSR.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        ArrayList selectionListCount = new ArrayList();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predCountList.add(CSRSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)col);
            predCountList.add(CSRSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, null, (String)"", selectionListCount));
        }
        Predicate predCount = null;
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("buildPredicate selects {} elements ", (Object)nTotalElements);
        return new PageImpl(certViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static CSRView buildCSRViewFromObjArr(ArrayList<String> colList, Object[] objArr) {
        CSRView cv = new CSRView();
        int i = 0;
        for (String attribute : colList) {
            if (i >= objArr.length) {
                logger.debug("attribute '{}' exceeds objArr with #{} elements ", (Object)attribute, (Object)objArr.length);
                continue;
            }
            logger.debug("attribute '{}' has value '{}'", (Object)attribute, objArr[i]);
            if ("id".equalsIgnoreCase(attribute)) {
                cv.setId((Long)objArr[i]);
            } else if ("certificateId".equalsIgnoreCase(attribute)) {
                cv.setCertificateId((Long)objArr[i]);
            } else if ("status".equalsIgnoreCase(attribute)) {
                cv.setStatus((CsrStatus)objArr[i]);
            } else if ("subject".equalsIgnoreCase(attribute)) {
                cv.setSubject((String)objArr[i]);
            } else if ("sans".equalsIgnoreCase(attribute)) {
                cv.setSans((String)objArr[i]);
            } else if ("publicKeyAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setPublicKeyAlgorithm((String)objArr[i]);
            } else if ("signingAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setSigningAlgorithm((String)objArr[i]);
            } else if ("keyLength".equalsIgnoreCase(attribute)) {
                cv.setKeyLength(objArr[i].toString());
            } else if ("x509KeySpec".equalsIgnoreCase(attribute)) {
                cv.setX509KeySpec((String)objArr[i]);
            } else if ("requestedBy".equalsIgnoreCase(attribute)) {
                cv.setRequestedBy((String)objArr[i]);
            } else if ("processingCA".equalsIgnoreCase(attribute)) {
                cv.setProcessingCA((String)objArr[i]);
            } else if ("pipelineName".equalsIgnoreCase(attribute)) {
                cv.setPipelineName((String)objArr[i]);
            } else if ("pipelineType".equalsIgnoreCase(attribute)) {
                cv.setPipelineType((PipelineType)objArr[i]);
            } else if ("requestedOn".equalsIgnoreCase(attribute)) {
                cv.setRequestedOn((Instant)objArr[i]);
            } else if ("rejectedOn".equalsIgnoreCase(attribute)) {
                cv.setRejectedOn((Instant)objArr[i]);
            } else if ("rejectionReason".equalsIgnoreCase(attribute)) {
                cv.setRejectionReason((String)objArr[i]);
            } else {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return cv;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = CSRSpecifications.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = CSRSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = CSRSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<CSR> root, CriteriaBuilder cb, CriteriaQuery<?> csrQuery, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.id));
            pred = CSRSpecifications.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.id), (String)attributeValue);
        } else if ("status".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.status));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicateCsrStatus((String)attributeSelector, (CriteriaBuilder)cb, (Path)root.get(CSR_.status), (String)attributeValue);
            }
        } else if ("certificateId".equals(attribute)) {
            Join certJoin = root.join(CSR_.certificate, JoinType.LEFT);
            CSRSpecifications.addNewColumn(selectionList, (Selection)certJoin.get(Certificate_.id));
        } else if ("subject".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.subject));
            if (attributeValue.trim().length() > 0) {
                Subquery csrAttSubquery = csrQuery.subquery(CsrAttribute.class);
                Root csrAttRoot = csrAttSubquery.from(CsrAttribute.class);
                pred = cb.exists(csrAttSubquery.select((Expression)csrAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)csrAttRoot.get("csr"), (Expression)root.get("id")), cb.equal((Expression)csrAttRoot.get("name"), (Object)"SUBJECT"), CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)csrAttRoot.get(CsrAttribute_.value), (String)attributeValue.toLowerCase())})));
            }
        } else if ("sans".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.sans));
            if (attributeValue.trim().length() > 0) {
                Subquery csrAttSubquery = csrQuery.subquery(CsrAttribute.class);
                Root csrAttRoot = csrAttSubquery.from(CsrAttribute.class);
                pred = cb.exists(csrAttSubquery.select((Expression)csrAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)csrAttRoot.get("csr"), (Expression)root.get("id")), cb.equal((Expression)csrAttRoot.get("name"), (Object)"SAN"), CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)csrAttRoot.get(CsrAttribute_.value), (String)attributeValue.toLowerCase())})));
            }
        } else if ("publicKeyAlgorithm".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.publicKeyAlgorithm));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.publicKeyAlgorithm), (String)attributeValue);
            }
        } else if ("signingAlgorithm".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.signingAlgorithm));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.signingAlgorithm), (String)attributeValue);
            }
        } else if ("x509KeySpec".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.x509KeySpec));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.x509KeySpec), (String)attributeValue);
            }
        } else if ("requestedBy".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.requestedBy));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.requestedBy), (String)attributeValue);
            }
        } else if ("pipelineName".equals(attribute)) {
            Join certJoin = root.join(CSR_.pipeline, JoinType.LEFT);
            CSRSpecifications.addNewColumn(selectionList, (Selection)certJoin.get(Pipeline_.name));
        } else if ("keyLength".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.keyLength));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicateInteger((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.keyLength), (String)attributeValue);
            }
        } else if ("requestedOn".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.requestedOn));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.requestedOn), (String)attributeValue);
            }
        } else if ("rejectedOn".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.rejectedOn));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.rejectedOn), (String)attributeValue);
            }
        } else if ("rejectionReason".equals(attribute)) {
            CSRSpecifications.addNewColumn(selectionList, (Selection)root.get(CSR_.rejectionReason));
            if (attributeValue.trim().length() > 0) {
                pred = CSRSpecifications.buildPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(CSR_.rejectionReason), (String)attributeValue);
            }
        } else {
            logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
        }
        return pred;
    }

    private static Predicate buildPredicateCsrStatus(String attributeSelector, CriteriaBuilder cb, Path<CsrStatus> path, String attributeValue) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        CsrStatus csrStatus = CsrStatus.valueOf((String)attributeValue);
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateCsrStatus equal ('{}') for value '{}'", (Object)attributeSelector, (Object)csrStatus);
            return cb.equal(path, (Object)csrStatus);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateCsrStatus notEqual ('{}') for value '{}'", (Object)attributeSelector, (Object)csrStatus);
            return cb.notEqual(path, (Object)csrStatus);
        }
        logger.debug("buildPredicateCsrStatus defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)csrStatus);
        return cb.equal(path, (Object)csrStatus);
    }

    private static void addNewColumn(List<Selection<?>> selectionList, Selection<?> sel) {
        if (!selectionList.contains(sel)) {
            selectionList.add(sel);
        }
    }

    private static Predicate buildPredicate(String attributeSelector, CriteriaBuilder cb, Expression<String> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.equal(expression, (Object)value);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate not equal ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.notEqual(expression, (Object)value);
        }
        if (Selector.ON.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate on ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.equal(expression, (Object)value);
        }
        if (Selector.LIKE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate like ('{}') for value '{}'", (Object)attributeSelector, (Object)CSRSpecifications.getContainsLikePattern((String)value));
            return cb.like(expression, CSRSpecifications.getContainsLikePattern((String)value));
        }
        if (Selector.NOTLIKE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate not like ('{}') for value '{}'", (Object)attributeSelector, (Object)CSRSpecifications.getContainsLikePattern((String)value));
            return cb.like(expression, CSRSpecifications.getContainsLikePattern((String)value)).not();
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.lessThan(expression, (Comparable)((Object)value));
        }
        if (Selector.BEFORE.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate before ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.lessThan(expression, (Comparable)((Object)value));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.greaterThan(expression, (Comparable)((Object)value));
        }
        if (Selector.AFTER.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate after ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
            return cb.greaterThan(expression, (Comparable)((Object)value));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)value);
        return cb.equal(expression, (Object)value);
    }

    private static Predicate buildPredicateLong(String attributeSelector, CriteriaBuilder cb, Expression<Long> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        long lValue = Long.parseLong(value.trim());
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.equal(expression, (Object)lValue);
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.lessThan(expression, (Comparable)Long.valueOf(lValue));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.greaterThan(expression, (Comparable)Long.valueOf(lValue));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
        return cb.equal(expression, (Object)lValue);
    }

    private static Predicate buildPredicateInteger(String attributeSelector, CriteriaBuilder cb, Expression<Integer> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        int lValue = Integer.parseInt(value.trim());
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate equal ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.equal(expression, (Object)lValue);
        }
        if (Selector.LESSTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate lessThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.lessThan(expression, (Comparable)Integer.valueOf(lValue));
        }
        if (Selector.GREATERTHAN.toString().equals(attributeSelector)) {
            logger.debug("buildPredicate greaterThan ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
            return cb.greaterThan(expression, (Comparable)Integer.valueOf(lValue));
        }
        logger.debug("buildPredicate defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)lValue);
        return cb.equal(expression, (Object)lValue);
    }

    private static Predicate buildBooleanPredicate(String attributeSelector, CriteriaBuilder cb, Expression<Boolean> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        logger.debug("buildBooleanPredicatedefaults to equals ('{}') ", (Object)attributeSelector);
        if (Selector.ISTRUE.toString().equals(attributeSelector)) {
            return cb.equal(expression, (Object)Boolean.TRUE);
        }
        return cb.equal(expression, (Object)Boolean.FALSE);
    }

    private static Predicate buildDatePredicate(String attributeSelector, CriteriaBuilder cb, Expression<Instant> expression, String value) {
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        try {
            Instant dateTime;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateTime = DateUtil.asInstant((Date)dateFormat.parse(value));
            }
            catch (Exception ex) {
                dateTime = Instant.ofEpochMilli(Long.parseLong(value));
            }
            if (Selector.ON.toString().equals(attributeSelector)) {
                Instant dateTimeStart = dateTime.plus(1L, ChronoUnit.HOURS).truncatedTo(ChronoUnit.DAYS);
                Instant dateTimeEnd = dateTimeStart.plus(1L, ChronoUnit.DAYS);
                logger.debug("buildDatePredicate on ('{}') for value > {} and < {}", new Object[]{attributeSelector, dateTimeStart, dateTimeEnd});
                return cb.and((Expression)cb.lessThanOrEqualTo(expression, (Comparable)dateTimeEnd), (Expression)cb.greaterThanOrEqualTo(expression, (Comparable)dateTimeStart));
            }
            if (Selector.BEFORE.toString().equals(attributeSelector)) {
                logger.debug("buildDatePredicate before ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
                return cb.lessThanOrEqualTo(expression, (Comparable)dateTime);
            }
            if (Selector.AFTER.toString().equals(attributeSelector)) {
                logger.debug("buildDatePredicate after ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
                return cb.greaterThanOrEqualTo(expression, (Comparable)dateTime);
            }
            logger.debug("buildDatePredicate defaults to equals ('{}') for value {}", (Object)attributeSelector, (Object)dateTime);
            return cb.equal(expression, (Object)dateTime);
        }
        catch (Exception ex) {
            logger.debug("parsing date ... ", (Throwable)ex);
            return cb.conjunction();
        }
    }
}

