/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.AuditTrace_;
import de.trustable.ca3s.core.domain.CSR_;
import de.trustable.ca3s.core.domain.Certificate_;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.AuditTraceView;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AuditTraceSpecifications {
    static Logger logger = LoggerFactory.getLogger(AuditTraceSpecifications.class);

    private AuditTraceSpecifications() {
    }

    public static Page<AuditTraceView> handleQueryParamsCertificateView(EntityManager entityManager, CriteriaBuilder cb, Map<String, String[]> parameterMap) {
        String[] paramArr;
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(AuditTrace.class);
        String sortCol = SpecificationsHelper.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = SpecificationsHelper.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = SpecificationsHelper.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = SpecificationsHelper.getIntValue((String[])parameterMap.get("limit"), (int)20);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = SpecificationsHelper.getSelectionMap(parameterMap);
        String[] columnArr = new String[]{};
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(AuditTraceSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(AuditTraceSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        List listResponse = typedQuery.getResultList();
        ArrayList<AuditTraceView> certViewList = new ArrayList<AuditTraceView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            AuditTraceView cv = AuditTraceSpecifications.buildAuditTraceViewFromObjArr(colList, (Object[])objArr);
            certViewList.add(cv);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        Long nTotalElements = 1000L;
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(AuditTrace.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        ArrayList selectionListCount = new ArrayList();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predCountList.add(AuditTraceSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)col);
            predCountList.add(AuditTraceSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, null, (String)"", selectionListCount));
        }
        Predicate predCount = null;
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("buildPredicate selects {} elements ", (Object)nTotalElements);
        return new PageImpl(certViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static AuditTraceView buildAuditTraceViewFromObjArr(ArrayList<String> colList, Object[] objArr) {
        AuditTraceView atv = new AuditTraceView();
        int i = 0;
        for (String attribute : colList) {
            if (i >= objArr.length) {
                logger.debug("attribute '{}' exceeds objArr with #{} elements ", (Object)attribute, (Object)objArr.length);
                continue;
            }
            logger.debug("attribute '{}' has value '{}'", (Object)attribute, objArr[i]);
            if ("id".equalsIgnoreCase(attribute)) {
                atv.setId((Long)objArr[i]);
            } else if ("actorName".equalsIgnoreCase(attribute)) {
                atv.setActorName((String)objArr[i]);
            } else if ("actorRole".equalsIgnoreCase(attribute)) {
                atv.setActorRole((String)objArr[i]);
            } else if ("contentTemplate".equalsIgnoreCase(attribute)) {
                atv.setContentTemplate((String)objArr[i]);
            } else if ("plainContent".equalsIgnoreCase(attribute)) {
                atv.setPlainContent((String)objArr[i]);
            } else if ("createdOn".equalsIgnoreCase(attribute)) {
                atv.setCreatedOn((Instant)objArr[i]);
            } else if ("certificateId".equalsIgnoreCase(attribute)) {
                atv.setCertificateId((Long)objArr[i]);
            } else if ("csrId".equalsIgnoreCase(attribute)) {
                atv.setCsrId((Long)objArr[i]);
            } else if ("caConnectorIdId".equalsIgnoreCase(attribute)) {
                atv.setCaConnectorId((Long)objArr[i]);
            } else if ("pipelineId".equalsIgnoreCase(attribute)) {
                atv.setPipelineId((Long)objArr[i]);
            } else if ("processInfoId".equalsIgnoreCase(attribute)) {
                atv.setProcessInfoId((Long)objArr[i]);
            } else {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return atv;
    }

    private static Predicate buildPredicate(Root<AuditTrace> root, CriteriaBuilder cb, CriteriaQuery<?> csrQuery, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.id));
            pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AuditTrace_.id), (String)attributeValue);
        } else if ("actorName".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.actorName));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AuditTrace_.actorName), (String)attributeValue);
            }
        } else if ("actorRole".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.actorRole));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AuditTrace_.actorRole), (String)attributeValue);
            }
        } else if ("createdOn".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.createdOn));
        } else if ("links".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.certificate));
        } else if ("certificateId".equals(attribute)) {
            Join certJoin = root.join(AuditTrace_.certificate, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)certJoin.get(Certificate_.id));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certJoin.get(Certificate_.id), (String)attributeValue);
            }
        } else if ("csrId".equals(attribute)) {
            Join csrJoin = root.join(AuditTrace_.csr, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)csrJoin.get(CSR_.id));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)csrJoin.get(CSR_.id), (String)attributeValue);
            }
        } else if ("contentTemplate".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.contentTemplate));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AuditTrace_.contentTemplate), (String)attributeValue);
            }
        } else if ("plainContent".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AuditTrace_.plainContent));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AuditTrace_.plainContent), (String)attributeValue);
            }
        } else {
            logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
        }
        return pred;
    }
}

