/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcsCertUtil;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Variant;
import de.trustable.ca3s.adcsCertAdmin.CCertAdmin;
import de.trustable.ca3s.adcsCertAdmin.CCertView;
import de.trustable.ca3s.adcsCertAdmin.IEnumCERTVIEWCOLUMN;
import de.trustable.ca3s.adcsCertAdmin.IEnumCERTVIEWROW;
import de.trustable.ca3s.adcsCertCli.CCertConfig;
import de.trustable.ca3s.adcsCertCli.CCertRequest;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSInstanceDetails;
import de.trustable.ca3s.adcsCertUtil.ADCSWinNativeConnector;
import de.trustable.ca3s.adcsCertUtil.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcsCertUtil.GetCertificateResponse;
import de.trustable.ca3s.adcsCertUtil.NoLocalADCSException;
import de.trustable.ca3s.adcsCertUtil.OODBConnectionsADCSException;
import de.trustable.ca3s.adcsCertUtil.SingleCertView;
import de.trustable.ca3s.adcsCertUtil.SubmitStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADCSNativeImpl
implements ADCSWinNativeConnector {
    public static final String CA_DETAILS_TYPE_INTERMEDIATE = "Intermediate";
    public static final String CA_DETAILS_TYPE_ROOT = "Root";
    static final int CVRC_COLUMN_SCHEMA = 0;
    static final int CVR_SEEK_EQ = 1;
    static final int CVR_SEEK_GE = 8;
    static final int CVR_SEEK_GT = 16;
    static final int CVR_SORT_NONE = 0;
    static final int CVR_SORT_ASCEND = 1;
    static final int CV_COLUMN_LOG_DEFAULT = -2;
    static final int CC_LOCALACTIVECONFIG = 4;
    static final int CR_PROP_FILEVERSION = 1;
    static final int CR_PROP_PRODUCTVERSION = 2;
    static final int CR_PROP_CANAME = 6;
    static final int CR_PROP_PARENTCA = 9;
    static final int CR_PROP_CATYPE = 10;
    static final int CR_PROP_CASIGCERTCOUNT = 11;
    static final int CR_PROP_CASIGCERT = 12;
    static final int CR_PROP_CASIGCERTCHAIN = 13;
    static final int CR_PROP_DNSNAME = 22;
    static final int CR_PROP_TEMPLATES = 29;
    static final int CR_PROP_SUBJECTTEMPLATE_OIDS = 45;
    static final int PROPTYPE_LONG = 1;
    static final int PROPTYPE_BINARY = 3;
    static final int PROPTYPE_STRING = 4;
    static final int CA_TYPE_ROOT = 3;
    static final int CA_TYPE_INTERMEDIATE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(ADCSNativeImpl.class);
    Factory factReadOnly = new Factory();
    Factory factModify = new Factory();
    CCertView cCertViewPEM;
    IEnumCERTVIEWROW certRowPEM;
    String config = this.getConfig(this.factReadOnly);

    private String getConfig(Factory fact) throws NoLocalADCSException, ADCSException {
        CCertConfig cCertConf = (CCertConfig)fact.createObject(CCertConfig.class);
        String config = "";
        try {
            config = cCertConf.GetConfig(Integer.valueOf(4));
        }
        catch (Throwable th) {
            COMException comEx = this.getCOMException(th);
            if (comEx == null) {
                LOG.warn("non-comEx : ", th);
            }
            String msg = comEx.getExcepInfo().toString();
            if (comEx.getExcepInfo().scode.intValue() == -2147024894 || comEx.getExcepInfo().scode.intValue() == -2147024637) {
                LOG.info("ADCS not available");
                throw new NoLocalADCSException(msg);
            }
            LOG.debug("comEx : " + msg);
            throw new ADCSException(th.getMessage());
        }
        LOG.debug("iCertConf : " + config);
        return config;
    }

    @Override
    public String getInfo() throws ADCSException {
        LOG.debug("getInfo");
        return this.getConfig(this.factReadOnly);
    }

    @Override
    public CertificateEnrollmentResponse submitRequest(String b64Csr, Map<String, String> attributeMap) throws ADCSException {
        LOG.debug("submitRequest starting ");
        try {
            CCertRequest cCertReq = (CCertRequest)this.factModify.createObject(CCertRequest.class);
            Integer requestFormatFlags = 0;
            StringBuffer strbufAttributes = new StringBuffer();
            for (String key : attributeMap.keySet()) {
                String value = attributeMap.get(key);
                if (strbufAttributes.length() > 0) {
                    strbufAttributes.append("\n");
                }
                strbufAttributes.append(key).append(":").append(value);
            }
            LOG.debug("request attribute list : '" + strbufAttributes.toString() + "'");
            Integer status = cCertReq.Submit(requestFormatFlags, b64Csr, strbufAttributes.toString(), this.config);
            int reqId = cCertReq.GetRequestId();
            LOG.debug("Request Id : " + reqId + " has status : " + status);
            CertificateEnrollmentResponse certResp = null;
            switch (status) {
                case 0: {
                    LOG.error("Request incomplete");
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.INCOMPLETE, reqId);
                    break;
                }
                case 1: {
                    LOG.error("Submitting request failed ");
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.ERROR, reqId);
                    break;
                }
                case 2: {
                    LOG.warn("Request denied");
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.DENIED, reqId);
                    break;
                }
                case 3: {
                    LOG.debug("Request issued");
                    String b64Cert = this.retrieveEnrolledCertificate(cCertReq, this.config, reqId);
                    String b64CaCert = cCertReq.GetCACertificate(Integer.valueOf(0), this.config, Integer.valueOf(0));
                    LOG.debug("cCertReq GetCACertificate : " + b64CaCert);
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.ISSUED, reqId, b64Cert, b64CaCert);
                    break;
                }
                case 4: {
                    LOG.warn("Request issued 'out of band'");
                    break;
                }
                case 5: {
                    LOG.debug("Request under submission");
                    String b64Cert2 = this.resubmitRequest(this.factModify, this.config, cCertReq);
                    LOG.debug("Certificate issued : \n" + b64Cert2);
                    String b64CaCert2 = cCertReq.GetCACertificate(Integer.valueOf(0), this.config, Integer.valueOf(0));
                    LOG.debug("cCertReq GetCACertificate : " + b64CaCert2);
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.ISSUED, reqId, b64Cert2, b64CaCert2);
                    break;
                }
                case 6: {
                    LOG.warn("Request revoked");
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.REVOKED, reqId);
                    break;
                }
                default: {
                    LOG.error("Unexected request status " + status);
                    certResp = new CertificateEnrollmentResponse(SubmitStatus.ERROR, reqId);
                }
            }
            CertificateEnrollmentResponse certificateEnrollmentResponse = certResp;
            return certificateEnrollmentResponse;
        }
        catch (RuntimeException rt) {
            this.handleCOMException(rt);
            throw rt;
        }
        catch (Exception e) {
            LOG.info("pool handling eyxception : ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        finally {
            System.gc();
        }
    }

    private String resubmitRequest(Factory fact, String config, CCertRequest cCertReq) throws ADCSException {
        int reqId = cCertReq.GetRequestId();
        LOG.debug("resubmitRequest for reqId : " + reqId);
        CCertAdmin cCertAdmin = (CCertAdmin)fact.createObject(CCertAdmin.class);
        LOG.debug("cCertAdmin for resubmitRequest : " + cCertAdmin);
        Integer status = cCertAdmin.ResubmitRequest(config, Integer.valueOf(reqId));
        LOG.debug("status : " + status);
        String statusAsHex = Integer.toHexString(status);
        LOG.debug("Resubmit status : 0x" + statusAsHex);
        if (status == 3) {
            String certB64 = this.retrieveEnrolledCertificate(cCertReq, config, reqId);
            return certB64;
        }
        if (status == -2146885613) {
            LOG.error("Revocation Server Offline Error : 0x" + statusAsHex);
            throw new ADCSException("resubmitting request failed : Revocation Server Offline Error : 0x" + statusAsHex);
        }
        LOG.error("Unexected resubmit request status 0x" + statusAsHex);
        throw new ADCSException("resubmitting request failed with response 0x" + statusAsHex);
    }

    private String retrieveEnrolledCertificate(CCertRequest cCertReq, String config, int reqId) {
        cCertReq.RetrievePending(Integer.valueOf(reqId), config);
        return cCertReq.GetCertificate(Integer.valueOf(0));
    }

    @Override
    public void revokeCertifcate(String serial, int reason, Date revocationDate) throws ADCSException {
        LOG.debug("revokeCertifcate starting ");
        CCertAdmin cCertAdmin = (CCertAdmin)this.factModify.createObject(CCertAdmin.class);
        try {
            LOG.debug("revokeCertificate param {}, '{}', {} ", new Object[]{this.config, serial, reason});
            cCertAdmin.RevokeCertificate(this.config, serial, Integer.valueOf(reason), revocationDate);
        }
        catch (RuntimeException rt) {
            this.handleCOMException(rt);
            throw rt;
        }
        catch (Exception e) {
            LOG.info("pool handling exception : ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        finally {
            System.gc();
        }
    }

    public List<String> getRequesIdList(int offset, int limit) throws ADCSException {
        return this.getRequesIdList(limit, offset, 0L, 0L);
    }

    public List<String> getRequesIdResolvedList(long resolvedWhenMinTimestamp, int limit) throws ADCSException {
        return this.getRequesIdList(limit, 0, resolvedWhenMinTimestamp, 0L);
    }

    public List<String> getRequesIdRevokedList(long revokedWhenMinTimestamp, int limit) throws ADCSException {
        return this.getRequesIdList(limit, 0, 0L, revokedWhenMinTimestamp);
    }

    @Override
    public List<String> getRequesIdList(int limit, int offset, long resolvedWhenMinTimestamp, long revokedWhenMinTimestamp) throws ADCSException {
        LOG.debug("getRequestList starting for #{} items limited by offset {}, resolvedWhenMinTimestamp {}, revokedWhenMinTimestamp {}", new Object[]{limit, offset, resolvedWhenMinTimestamp, revokedWhenMinTimestamp});
        ArrayList<String> retList = new ArrayList<String>();
        try {
            CCertView cCertView = this.createMultipleCertView(false);
            if (resolvedWhenMinTimestamp > 0L) {
                Date resolvedDate = new Date(resolvedWhenMinTimestamp);
                Variant.VARIANT v = new Variant.VARIANT(resolvedDate);
                cCertView.SetRestriction(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.ResolvedWhen"), Integer.valueOf(16), Integer.valueOf(1), (Object)v);
                LOG.debug("getRequestList limited by resolvedWhenTimestamp > {} ", (Object)resolvedDate);
            } else if (revokedWhenMinTimestamp > 0L) {
                Variant.VARIANT v = new Variant.VARIANT(new Date(revokedWhenMinTimestamp));
                cCertView.SetRestriction(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.RevokedEffectiveWhen"), Integer.valueOf(16), Integer.valueOf(1), (Object)v);
                LOG.debug("getRequestList limited by revokedEffectiveWhen > {} ", (Object)new Date(revokedWhenMinTimestamp));
            } else {
                cCertView.SetRestriction(cCertView.GetColumnIndex(Integer.valueOf(0), "RequestID"), Integer.valueOf(16), Integer.valueOf(1), (Object)offset);
                LOG.debug("getRequestList limited by requestId > {} ", (Object)offset);
            }
            IEnumCERTVIEWROW certRow = cCertView.OpenView();
            certRow.Reset();
            while (certRow.Next() != -1) {
                IEnumCERTVIEWCOLUMN cols = certRow.EnumCertViewColumn();
                cols.Reset();
                String requestId = "";
                int col = 0;
                while (cols.Next() != -1) {
                    LOG.debug("#" + col + ": " + cols.GetName() + " " + cols.GetType() + " " + cols.GetValue(Integer.valueOf(0)));
                    if (col == 0) {
                        requestId = cols.GetValue(Integer.valueOf(0)).toString();
                        retList.add(requestId);
                    }
                    ++col;
                }
                if (retList.size() >= limit) {
                    LOG.debug("limit (" + limit + ") of result rows reached");
                    break;
                }
                LOG.debug("current result set has size #{}", (Object)retList.size());
            }
        }
        catch (RuntimeException rt) {
            LOG.info("Runtime exception :", (Throwable)rt);
            this.handleCOMException(rt);
            throw rt;
        }
        catch (Exception e) {
            LOG.info("pool handling eyxception : ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        finally {
            System.gc();
        }
        return retList;
    }

    CCertView createMultipleCertView(boolean includePEM) throws ADCSException {
        LOG.debug("createMultipleCertView ");
        CCertView cCertView = this.createCertView();
        Integer nColumn = 3;
        if (includePEM) {
            Integer n = nColumn;
            Integer n2 = nColumn = Integer.valueOf(nColumn + 1);
        }
        cCertView.SetResultColumnCount(nColumn);
        int requestIDColumnIndex = cCertView.GetColumnIndex(Integer.valueOf(0), "RequestID");
        int resolvedDateColumnIndex = cCertView.GetColumnIndex(Integer.valueOf(0), "Request.ResolvedWhen");
        int revokedDateColumnIndex = cCertView.GetColumnIndex(Integer.valueOf(0), "Request.RevokedEffectiveWhen");
        cCertView.SetResultColumn(Integer.valueOf(requestIDColumnIndex));
        cCertView.SetResultColumn(Integer.valueOf(resolvedDateColumnIndex));
        cCertView.SetResultColumn(Integer.valueOf(revokedDateColumnIndex));
        if (includePEM) {
            int certColumnIndex = cCertView.GetColumnIndex(Integer.valueOf(0), "RawCertificate");
            cCertView.SetResultColumn(Integer.valueOf(certColumnIndex));
        }
        return cCertView;
    }

    @Override
    public GetCertificateResponse getCertificateByRequestId(String reqId) throws ADCSException {
        LOG.debug("getCertificateByRequestId({})", (Object)reqId);
        try {
            SingleCertView scv = this.createSingleCertView();
            scv.getcCertView().SetRestriction(scv.getcCertView().GetColumnIndex(Integer.valueOf(0), "RequestID"), Integer.valueOf(1), Integer.valueOf(0), (Object)Integer.parseInt(reqId));
            GetCertificateResponse getCertificateResponse = this.getRow(scv.getCertRowPEM());
            return getCertificateResponse;
        }
        catch (RuntimeException rt) {
            this.handleCOMException(rt);
            throw rt;
        }
        catch (Exception e) {
            LOG.info("general exception : ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        finally {
            System.gc();
        }
    }

    private GetCertificateResponse getRow(IEnumCERTVIEWROW certRow) {
        if (certRow != null) {
            certRow.Reset();
            int ret = 0;
            int row = 0;
            if (this.hasMore(certRow)) {
                LOG.debug("ret : " + ret + ", row : " + row++);
                IEnumCERTVIEWCOLUMN cols = certRow.EnumCertViewColumn();
                cols.Next();
                LOG.info("" + cols.GetName() + " " + cols.GetType() + " " + cols.GetValue(Integer.valueOf(0)));
                String requestID = cols.GetValue(Integer.valueOf(0)).toString();
                String b64Cert = "";
                String template = "";
                String resolvedDate = "";
                String revokedDate = "";
                String revokedReason = "";
                String disposition = "";
                String dispositionMessage = "";
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    b64Cert = cols.GetValue(Integer.valueOf(0)).toString();
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    template = cols.GetValue(Integer.valueOf(0)).toString();
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    resolvedDate = Long.toString(((Date)cols.GetValue(Integer.valueOf(0))).getTime());
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    revokedDate = Long.toString(((Date)cols.GetValue(Integer.valueOf(0))).getTime());
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    revokedReason = cols.GetValue(Integer.valueOf(0)).toString();
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    disposition = cols.GetValue(Integer.valueOf(0)).toString();
                }
                cols.Next();
                if (cols.GetValue(Integer.valueOf(0)) != null) {
                    dispositionMessage = cols.GetValue(Integer.valueOf(0)).toString();
                }
                return new GetCertificateResponse(requestID, b64Cert, template, resolvedDate, revokedDate, revokedReason, disposition, dispositionMessage);
            }
        }
        return null;
    }

    private boolean hasMore(IEnumCERTVIEWROW certRow) {
        Integer intNext = certRow.Next();
        return intNext != null && intNext != -1;
    }

    public SingleCertView createSingleCertView() throws ADCSException {
        LOG.debug("create new SingleCertView");
        CCertView cCertView = this.createCertView();
        Integer nColumn = 8;
        cCertView.SetResultColumnCount(nColumn);
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "RequestID"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "RawCertificate"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "CertificateTemplate"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.ResolvedWhen"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.RevokedEffectiveWhen"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.RevokedReason"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.Disposition"));
        cCertView.SetResultColumn(cCertView.GetColumnIndex(Integer.valueOf(0), "Request.DispositionMessage"));
        IEnumCERTVIEWROW certRowPEM = cCertView.OpenView();
        return new SingleCertView(cCertView, certRowPEM);
    }

    public CCertView createCertView() throws ADCSException {
        LOG.debug("create new CCertView ");
        CCertView cCertView = (CCertView)this.factReadOnly.createObject(CCertView.class);
        cCertView.OpenConnection(this.config);
        return cCertView;
    }

    @Override
    public String[] getCATemplates() throws ADCSException {
        CCertRequest certReq = (CCertRequest)this.factReadOnly.createObject(CCertRequest.class);
        try {
            String templateString = certReq.GetCAProperty(this.getInfo(), Integer.valueOf(29), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
            if (templateString == null) {
                return new String[0];
            }
            String[] pairArr = templateString.split("\n");
            String[] nameArr = new String[pairArr.length / 2];
            int i = 0;
            int j = 0;
            while (i < pairArr.length) {
                nameArr[j] = pairArr[i];
                i += 2;
                ++j;
            }
            return nameArr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    @Override
    public ADCSInstanceDetails getCAInstanceDetails() throws ADCSException {
        ADCSInstanceDetails aiDetails = new ADCSInstanceDetails();
        CCertRequest certReq = (CCertRequest)this.factReadOnly.createObject(CCertRequest.class);
        try {
            String templateString;
            String info = this.getInfo();
            String caName = certReq.GetCAProperty(info, Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
            aiDetails.setCaName(caName);
            Integer type = (Integer)certReq.GetCAProperty(info, Integer.valueOf(10), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
            if (3 == type) {
                aiDetails.setCaType(CA_DETAILS_TYPE_ROOT);
            } else if (4 == type) {
                aiDetails.setCaType(CA_DETAILS_TYPE_INTERMEDIATE);
            } else {
                aiDetails.setCaType("Unknown type " + type);
            }
            try {
                String fileVersion = certReq.GetCAProperty(info, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                aiDetails.setFileVersion(fileVersion);
            }
            catch (Exception ex) {
                LOG.debug("problem calling for fileVersion: " + ex.getMessage());
            }
            try {
                String productVersion = certReq.GetCAProperty(info, Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                aiDetails.setProductVersion(productVersion);
            }
            catch (Exception ex) {
                LOG.debug("problem calling for productVersion: " + ex.getMessage());
            }
            try {
                String parentCA = certReq.GetCAProperty(info, Integer.valueOf(9), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                aiDetails.setParentCaName(parentCA);
            }
            catch (Exception ex) {
                LOG.debug("problem calling for parentCA: " + ex.getMessage());
            }
            try {
                String dnsName = certReq.GetCAProperty(info, Integer.valueOf(22), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                aiDetails.setDnsName(dnsName);
            }
            catch (Exception ex) {
                LOG.debug("problem calling for dnsName: " + ex.getMessage());
            }
            try {
                Integer count = (Integer)certReq.GetCAProperty(info, Integer.valueOf(11), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
                String[] sigCertArr = new String[count.intValue()];
                for (int i = 0; i < count; ++i) {
                    sigCertArr[i] = certReq.GetCAProperty(info, Integer.valueOf(12), Integer.valueOf(i), Integer.valueOf(3), Integer.valueOf(0)).toString().replaceAll("\\r\\n", "\\n");
                }
                aiDetails.setSigningCerts(sigCertArr);
                String[] sigChainArr = new String[count.intValue()];
                for (int i = 0; i < count; ++i) {
                    sigChainArr[i] = certReq.GetCAProperty(info, Integer.valueOf(13), Integer.valueOf(i), Integer.valueOf(3), Integer.valueOf(0)).toString().replaceAll("\\r\\n", "\\n");
                }
                aiDetails.setSigningCertChains(sigChainArr);
            }
            catch (Exception ex) {
                LOG.debug("problem calling for signing certificates / chains: " + ex.getMessage());
            }
            try {
                templateString = certReq.GetCAProperty(info, Integer.valueOf(29), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                if (templateString != null) {
                    String[] pairArr = templateString.split("\n");
                    String[] nameArr = new String[pairArr.length / 2];
                    String[] oidArr = new String[pairArr.length / 2];
                    int i = 0;
                    int j = 0;
                    while (i < pairArr.length) {
                        nameArr[j] = pairArr[i];
                        oidArr[j] = pairArr[i + 1];
                        i += 2;
                        ++j;
                    }
                    aiDetails.setTemplates(nameArr);
                    aiDetails.setTemplateOIDs(oidArr);
                }
            }
            catch (Exception ex) {
                LOG.debug("problem calling for templates: " + ex.getMessage());
            }
            try {
                templateString = certReq.GetCAProperty(info, Integer.valueOf(45), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0)).toString();
                if (templateString != null) {
                    aiDetails.setSubjectTemplateOIDs(templateString.split("\n"));
                }
            }
            catch (Exception ex) {
                LOG.debug("problem calling for subjectTemplateOIDs: " + ex.getMessage());
            }
        }
        catch (Exception e) {
            LOG.warn("problem retrieving data for getCAInstanceDetails", (Throwable)e);
            throw new ADCSException(e.getMessage());
        }
        return aiDetails;
    }

    private void handleCOMException(RuntimeException rt) throws OODBConnectionsADCSException, ADCSException {
        COMException comEx = this.getCOMException(rt);
        if (comEx != null) {
            if ("-2146877425".equals(comEx.getExcepInfo().scode.toString())) {
                System.gc();
                throw new OODBConnectionsADCSException(comEx.getExcepInfo().toString());
            }
            throw new ADCSException(comEx.getExcepInfo().toString());
        }
        LOG.warn("handleCOMException: Not a COMException, rethrowing ...", (Throwable)rt);
    }

    COMException getCOMException(Throwable ex) {
        for (int i = 0; i < 10; ++i) {
            if (ex instanceof COMException) {
                return (COMException)ex;
            }
            if (ex.getCause() == null) break;
            ex = ex.getCause();
        }
        return null;
    }

    static {
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        LOG.info("Ole32.INSTANCE.CoInitializeEx called");
    }
}

