/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcsKeyStore.provider;

import de.trustable.ca3s.adcsKeyStore.provider.DummyPropertyProviderImpl;
import de.trustable.ca3s.adcsKeyStore.provider.LocalADCSProvider;
import de.trustable.ca3s.adcsKeyStore.provider.PropertyProvider;
import de.trustable.ca3s.adcsKeyStore.provider.SpringEnvironmentPropertyProviderImpl;
import de.trustable.ca3s.cert.bundle.KeyStoreImpl;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import java.security.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalADCSProvider
extends Provider {
    public static final String ALGO_NAME = "LocalADCS";
    private static final String STORE_TYPE_KEYSTORE = "Keystore";
    private static final long serialVersionUID = -2476288508778039686L;
    private static final Logger LOG = LoggerFactory.getLogger(LocalADCSProvider.class);
    private static PropertyProvider propProvider = new DummyPropertyProviderImpl();
    private static KeyStoreImpl keystoreImpl;

    public LocalADCSProvider(TimedRenewalCertMap certMap, SpringEnvironmentPropertyProviderImpl propProviderArg) {
        super("LocalADCSProvider", 1.0, "Keystore provider using local ADCS");
        propProvider = propProviderArg;
        String alias = propProvider.getProperty("server.tls.key.alias", "localADCSAlias");
        keystoreImpl = new KeyStoreImpl(certMap, alias);
        keystoreImpl.engineGetCertificate(alias);
        this.putService((Provider.Service)new ProviderService((Provider)this, STORE_TYPE_KEYSTORE, ALGO_NAME, KeyStoreImpl.class.getName()));
        LOG.debug("registered KeyStoreImpl in LocalADCSProvider");
        for (String prop : super.stringPropertyNames()) {
            LOG.info("provider attribute {} : '{}'", (Object)prop, (Object)this.getProperty(prop));
        }
    }
}

