/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcsKeyStore.provider;

import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalADCSKeyManager
extends X509ExtendedKeyManager {
    private final Logger log = LoggerFactory.getLogger(LocalADCSKeyManager.class);
    private TimedRenewalCertMap certMap;

    public LocalADCSKeyManager(TimedRenewalCertMap certMap) {
        this.certMap = certMap;
    }

    @Override
    public String[] getClientAliases(String arg0, Principal[] arg1) {
        this.log.debug("in getClientAliases(String arg0, Principal[] arg1)");
        return new String[0];
    }

    @Override
    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        this.log.debug("in chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2)");
        return null;
    }

    @Override
    public String[] getServerAliases(String arg0, Principal[] arg1) {
        Set aliasSet = this.certMap.aliases();
        String[] aliasArr = aliasSet.toArray(new String[aliasSet.size()]);
        this.log.debug("in getServerAliases(String[] arg0, Principal[] arg1), returning #{} aliases", (Object)aliasArr.length);
        return aliasArr;
    }

    @Override
    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        Set aliasSet = this.certMap.aliases();
        String alias = (String)aliasSet.iterator().next();
        this.log.debug("in chooseServerAlias(String[] arg0, Principal[] arg1, Socket arg2), returning alias '{}'", (Object)alias);
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyCertBundle bundle = this.certMap.findBundleForAlias(alias);
        if (bundle != null) {
            this.log.debug("in getCertificateChain('{}'), returning #{} certificates", (Object)alias, (Object)bundle.getCertificateChain().length);
            return bundle.getCertificateChain();
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyCertBundle bundle = this.certMap.findBundleForAlias(alias);
        if (bundle != null) {
            this.log.debug("in getPrivateKey('{}'), returning private key", (Object)alias);
            return (PrivateKey)bundle.getKey();
        }
        return null;
    }
}

