/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcsKeyStore.provider;

import de.trustable.ca3s.adcs.proxy.web.rest.LocalADCSService;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcsCertUtil.NoLocalADCSException;
import de.trustable.ca3s.adcsCertUtil.SubmitStatus;
import de.trustable.ca3s.adcsKeyStore.provider.PropertyProvider;
import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.util.CryptoUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalADCSBundleFactory
implements BundleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LocalADCSBundleFactory.class);
    public static final String KEY_STORE_PROPERTIES_PREFIX = "server.tls.";
    private static final String ADDITIONAL_SANS = "server.tls.additionalSANs";
    private static final String KEY_LENGTH = "server.tls.key.length";
    private static final String KEY_ALGO = "server.tls.key.algorithm";
    private static final String SIGNING_ALGO = "server.tls.signing.algorithm";
    private String keyAlgo = "RSA";
    private String signingAlgo = "SHA256withRSA";
    private int keylength = 2048;
    private String[] sanArr = new String[0];

    public LocalADCSBundleFactory(PropertyProvider propProvider) {
        LOG.debug("cTor LocalADCSBundleFactory(proProvider)");
        if (propProvider != null) {
            String san = propProvider.getProperty(ADDITIONAL_SANS, "");
            for (String additionalSan : this.sanArr = san.split(",")) {
                LOG.debug("additionalSan : " + additionalSan);
            }
            String length = propProvider.getProperty(KEY_LENGTH, "2048");
            this.keylength = Integer.parseUnsignedInt(length);
            this.keyAlgo = propProvider.getProperty(KEY_ALGO, "RSA");
            this.signingAlgo = propProvider.getProperty(SIGNING_ALGO, "SHA256withRSA");
        }
    }

    public KeyCertBundle newKeyBundle(String bundleName, long minValiditySeconds) throws GeneralSecurityException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.keyAlgo);
            keyGen.initialize(this.keylength);
            KeyPair kp = keyGen.genKeyPair();
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getCanonicalHostName();
            LOG.debug("requesting certificate for host : " + hostname);
            String csr = this.createCsrAsPEM(hostname, kp.getPublic(), kp.getPrivate());
            LocalADCSService adcsService = new LocalADCSService();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            if (bundleName.contains("@")) {
                String[] parts = bundleName.split("@");
                if (parts.length > 1) {
                    String template = parts[1].replaceAll(" ", "");
                    LOG.debug("requesting certificate using template : " + template);
                    attrMap.put("Certificate Template", template);
                } else {
                    LOG.warn("alias contains an '@', but it is not followed by a template name!");
                }
            } else {
                LOG.debug("requesting certificate using bundle name '{}' without a template. This is valid for non-domain ADCS instances.", (Object)bundleName);
            }
            CertificateEnrollmentResponse certResponse = adcsService.getADCSConnector().submitRequest(csr, attrMap);
            if (SubmitStatus.ISSUED.equals((Object)certResponse.getStatus())) {
                X509Certificate cert = CryptoUtil.convertPemToCertificate((String)certResponse.getB64Cert());
                X509Certificate caCert = CryptoUtil.convertPemToCertificate((String)certResponse.getB64CACert());
                X509Certificate[] caCertArr = new X509Certificate[]{cert, caCert};
                LOG.debug("succeeded to retrieve certificate from ADCS instance");
                return new KeyCertBundle(bundleName, caCertArr, cert, (Key)kp.getPrivate());
            }
            LOG.error("failed to retrieve certificate from ADCS instance, status : '{}', check request id {}", (Object)certResponse.getStatus(), (Object)certResponse.getReqId());
            throw new GeneralSecurityException("failed to retrieve certificate from ADCS instance!");
        }
        catch (NoLocalADCSException nlae) {
            LOG.error("ADCSConnector not available !");
            throw new GeneralSecurityException("ADCSConnector not available !", nlae);
        }
        catch (ADCSException | IOException ex) {
            LOG.warn("failed to retrieve certificate from ADCS instance", ex);
            throw new GeneralSecurityException("ADCSConnector not available !", ex);
        }
    }

    private String createCsrAsPEM(String hostname, PublicKey pubKey, PrivateKey priKey) throws GeneralSecurityException, IOException {
        ContentSigner signer;
        X500Principal subject = new X500Principal("CN=" + hostname);
        SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signingAlgo);
        try {
            signer = signerBuilder.build(priKey);
        }
        catch (OperatorCreationException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(X500Name.getInstance((Object)subject.getEncoded()), pkInfo);
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        ArrayList<GeneralName> namesList = new ArrayList<GeneralName>();
        boolean localhostRequested = "localhost".equalsIgnoreCase(hostname);
        for (String additionalSan : this.sanArr) {
            String name = additionalSan.trim();
            if (name.length() == 0) continue;
            LOG.debug("set additonal SAN: " + name);
            namesList.add(new GeneralName(2, name));
            if (!"localhost".equalsIgnoreCase(name)) continue;
            localhostRequested = true;
        }
        if (!localhostRequested) {
            namesList.add(new GeneralName(2, "localhost"));
        }
        namesList.add(new GeneralName(2, hostname.toLowerCase()));
        namesList.add(new GeneralName(7, "127.0.0.1"));
        GeneralNames subjectAltNames = new GeneralNames(namesList.toArray(new GeneralName[0]));
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
        PKCS10CertificationRequest req = builder.build(signer);
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)req);
        pemWriter.close();
        return stringWriter.toString();
    }
}

