/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import de.trustable.ca3s.adcs.proxy.web.dto.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcs.proxy.web.dto.CertificateRequestElements;
import de.trustable.ca3s.adcs.proxy.web.dto.CertificateRequestElementsAttributes;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSNativeImpl;
import de.trustable.ca3s.adcsCertUtil.ADCSWinNativeConnector;
import de.trustable.ca3s.adcsCertUtil.NoLocalADCSException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LocalADCSService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalADCSService.class);
    private ADCSWinNativeConnector adcsConnector;

    public LocalADCSService() {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (!isWindows) {
            LOGGER.info("ADCSConnector available on Windows, only");
        } else {
            LOGGER.debug("ADCSConnector cTor trying to load Windows native interface classes...");
            while (true) {
                try {
                    this.adcsConnector = new ADCSNativeImpl();
                    LOGGER.info("ADCSConnector cTor instantiated using Windows native interface");
                }
                catch (NoLocalADCSException nlae) {
                    LOGGER.info("### waiting for the ADCS to start ...");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                catch (UnsatisfiedLinkError ule) {
                    LOGGER.info("unable to load Windows connection classes, ADCS connection unavailable.", (Throwable)ule);
                }
                catch (ADCSException e) {
                    LOGGER.info("unable to load Windows connection classes, ADCS connection unavailable.", (Throwable)e);
                }
                break;
            }
        }
    }

    public LocalADCSService(ADCSWinNativeConnector adcsConnector) {
        this.adcsConnector = adcsConnector;
    }

    public ADCSWinNativeConnector getADCSConnector() {
        return this.adcsConnector;
    }

    public CertificateEnrollmentResponse requestCertificate(CertificateRequestElements cre) throws ADCSException {
        List reqAttributeList = cre.getAttributes();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (CertificateRequestElementsAttributes creAttr : reqAttributeList) {
            attrMap.put(creAttr.getName(), creAttr.getValue());
        }
        de.trustable.ca3s.adcsCertUtil.CertificateEnrollmentResponse adcsResp = this.getADCSConnector().submitRequest(cre.getCsr(), attrMap);
        CertificateEnrollmentResponse ceResp = new CertificateEnrollmentResponse();
        Integer reqIdInt = (int)adcsResp.getReqId();
        ceResp.reqId(reqIdInt);
        ceResp.status(adcsResp.getStatus().toString());
        ceResp.cert(adcsResp.getB64Cert());
        ceResp.certCA(adcsResp.getB64CACert());
        return ceResp;
    }
}

