/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.adcs.proxy.web.dto.CertificateArrayResponse;
import de.trustable.ca3s.adcs.proxy.web.dto.RequestIdsResponse;
import de.trustable.ca3s.adcs.proxy.web.rest.AdcsRequestsApi;
import de.trustable.ca3s.adcs.proxy.web.rest.LocalADCSService;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.OODBConnectionsADCSException;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdcsRequestsApiController
implements AdcsRequestsApi {
    private static final Logger log = LoggerFactory.getLogger(AdcsRequestsApiController.class);
    @Autowired
    private LocalADCSService localADCSService;
    private final HttpServletRequest request;

    @Autowired
    public AdcsRequestsApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity<RequestIdsResponse> getRequestIdList(@Parameter(description="The number of items to skip before starting to collect the result set. Either provide this parameter or resolvedWhenTimestamp or revokedWhenTimestamp.") @Valid @RequestParam(value="offset", required=false) Integer offset, @Parameter(description="The resolvedWhen value must be after this timestamp value. Either provide this parameter or offset or revokedWhenTimestamp.") @Valid @RequestParam(value="resolvedWhenTimestamp", required=false) Long resolvedWhenTimestamp, @Parameter(description="The revokedWhen value must be after this timestamp value. Either provide this parameter or resolvedWhenTimestamp or offset.") @Valid @RequestParam(value="revokedWhenTimestamp", required=false) Long revokedWhenTimestamp, @Parameter(description="The numbers of items to return") @Valid @RequestParam(value="limit", required=false) Integer limit) {
        String accept = this.request.getHeader("Accept");
        int intOffset = 0;
        if (offset != null) {
            intOffset = offset;
        }
        int intLimit = 1000;
        if (limit != null) {
            intLimit = limit;
        }
        long longResolvedWhenTimestamp = 0L;
        if (resolvedWhenTimestamp != null) {
            longResolvedWhenTimestamp = resolvedWhenTimestamp;
        }
        long longRevokedWhenTimestamp = 0L;
        if (revokedWhenTimestamp != null) {
            longRevokedWhenTimestamp = revokedWhenTimestamp;
        }
        if (intOffset < 0) {
            log.error("Unexpected offset '" + offset + "', expected to by >= 0 ");
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        if (intLimit < 0 || intLimit > 4096) {
            log.error("Unexpected limit '" + limit + "', expected to by >= 0 and < 4096");
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        if (accept != null && accept.contains("application/json")) {
            try {
                List adcsCertResp = this.localADCSService.getADCSConnector().getRequesIdList(intLimit, intOffset, longResolvedWhenTimestamp, longRevokedWhenTimestamp);
                RequestIdsResponse reqIdList = new RequestIdsResponse();
                for (String id : adcsCertResp) {
                    reqIdList.add((Object)id);
                }
                return new ResponseEntity((Object)reqIdList, HttpStatus.OK);
            }
            catch (OODBConnectionsADCSException e) {
                log.error("Out of DBCOnnections, try again later ...", (Throwable)e);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (ADCSException e) {
                log.error("Problem retrieving certificate list from '" + offset + "' with '" + limit + "' elements", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    public ResponseEntity<CertificateArrayResponse> getRequestsById(@Parameter(description="The number of items to skip before starting to collect the result set") @Valid @RequestParam(value="id", required=false) List<String> id) {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

