/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.adcs.proxy.web.dto.GetCertificateResponseValues;
import de.trustable.ca3s.adcs.proxy.web.rest.AdcsRequestApi;
import de.trustable.ca3s.adcs.proxy.web.rest.LocalADCSService;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSWinNativeConnector;
import de.trustable.ca3s.adcsCertUtil.GetCertificateResponse;
import de.trustable.ca3s.adcsCertUtil.OODBConnectionsADCSException;
import io.swagger.v3.oas.annotations.Parameter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class AdcsRequestApiController
implements AdcsRequestApi {
    private static final Logger log = LoggerFactory.getLogger(AdcsRequestApiController.class);
    @Autowired
    private LocalADCSService localADCSService;
    private final HttpServletRequest request;

    @Autowired
    public AdcsRequestApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity<de.trustable.ca3s.adcs.proxy.web.dto.GetCertificateResponse> getRequestById(@Parameter(description="certificate request id", required=true) @PathVariable(value="reqId") String reqId) {
        String accept = this.request.getHeader("Accept");
        log.debug("getRequestById for id '" + reqId + "'");
        if (accept != null && accept.contains("application/json")) {
            try {
                ADCSWinNativeConnector adcsConn = this.localADCSService.getADCSConnector();
                GetCertificateResponse adcsCertResp = adcsConn.getCertificateByRequestId(reqId);
                if (adcsCertResp != null) {
                    de.trustable.ca3s.adcs.proxy.web.dto.GetCertificateResponse getCertResp = new de.trustable.ca3s.adcs.proxy.web.dto.GetCertificateResponse();
                    this.addCertResponseElement("ReqId", adcsCertResp.getReqId(), getCertResp);
                    this.addCertResponseElement("Template", adcsCertResp.getTemplate(), getCertResp);
                    this.addCertResponseElement("ResolvedDate", adcsCertResp.getResolvedDate(), getCertResp);
                    this.addCertResponseElement("Cert", adcsCertResp.getB64Cert(), getCertResp);
                    this.addCertResponseElement("RevokedDate", adcsCertResp.getRevokedDate(), getCertResp);
                    this.addCertResponseElement("RevokedReason", adcsCertResp.getRevokedReason(), getCertResp);
                    this.addCertResponseElement("Disposition", adcsCertResp.getDisposition(), getCertResp);
                    this.addCertResponseElement("DispositionMessage", adcsCertResp.getDispositionMessage(), getCertResp);
                    return new ResponseEntity((Object)getCertResp, HttpStatus.OK);
                }
                log.debug("getRequestById for id '" + reqId + "': nothing found");
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            catch (OODBConnectionsADCSException e) {
                log.error("Out of DBCOnnections, try again later ...", (Throwable)e);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (ADCSException e) {
                log.error("Problem retrieving certificate with request id '" + reqId + "'", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    private void addCertResponseElement(String elementName, String value, de.trustable.ca3s.adcs.proxy.web.dto.GetCertificateResponse getCertResp) {
        if (value != null && value.trim().length() > 0) {
            GetCertificateResponseValues valuesItemReqId = new GetCertificateResponseValues();
            valuesItemReqId.setName(elementName);
            valuesItemReqId.setValue(value);
            getCertResp.addValuesItem(valuesItemReqId);
        }
    }
}

