/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.adcs.proxy.web.dto.ADCSInstanceDetailsResponse;
import de.trustable.ca3s.adcs.proxy.web.rest.AdcsInfoApi;
import de.trustable.ca3s.adcs.proxy.web.rest.LocalADCSService;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSInstanceDetails;
import de.trustable.ca3s.adcsCertUtil.NoLocalADCSException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;

@Controller
public class AdcsInfoApiController
implements AdcsInfoApi {
    private static final Logger log = LoggerFactory.getLogger(AdcsInfoApiController.class);
    @Autowired
    private LocalADCSService localADCSService;
    private final HttpServletRequest request;

    @Autowired
    public AdcsInfoApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity<String> getADCSInfo() {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                String info = this.localADCSService.getADCSConnector().getInfo();
                return new ResponseEntity((Object)info, HttpStatus.OK);
            }
            catch (NoLocalADCSException nlae) {
                log.error("Local ADCS not available, check status of ADCS instance!");
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (ADCSException e) {
                log.error("Problem retrieving ADCS info", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception ex) {
                log.error("Problem retrieving ADCS info", (Throwable)ex);
                return new ResponseEntity((Object)"", HttpStatus.OK);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<String[]> getCATemplates() {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                String[] templateArr = this.localADCSService.getADCSConnector().getCATemplates();
                return new ResponseEntity((Object)templateArr, HttpStatus.OK);
            }
            catch (NoLocalADCSException nlae) {
                log.error("Local ADCS not available, check status of ADCS instance!");
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (ADCSException e) {
                log.error("Problem retrieving ADCS info", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<ADCSInstanceDetailsResponse> getCAInstanceDetails() {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                ADCSInstanceDetails details = this.localADCSService.getADCSConnector().getCAInstanceDetails();
                return new ResponseEntity((Object)new ADCSInstanceDetailsResponse(details), HttpStatus.OK);
            }
            catch (NoLocalADCSException nlae) {
                log.error("Local ADCS not available, check status of ADCS instance!");
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (ADCSException e) {
                log.error("Problem retrieving ADCS info", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

