/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import de.trustable.ca3s.adcs.proxy.web.dto.ADCSInstanceDetailsResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Tag(name="adcsInfo", description="the adcsInfo API")
public interface AdcsInfoApi {
    @Operation(summary="get description of ADCS instance", description="get description of ADCS instance", responses={@ApiResponse(responseCode="200", description="ADCS info"), @ApiResponse(responseCode="401", description="authentication / authorization missing"), @ApiResponse(responseCode="503", description="ADCS server unavailable")})
    @RequestMapping(value={"/adcsInfo"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> getADCSInfo();

    @Operation(summary="get the templates available at this ADCS instance", description="get the templates available at this ADCS instance", responses={@ApiResponse(responseCode="200", description="Array of template names"), @ApiResponse(responseCode="401", description="authentication / authorization missing"), @ApiResponse(responseCode="503", description="ADCS server unavailable")})
    @RequestMapping(value={"/adcsTemplates"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String[]> getCATemplates();

    @Operation(summary="get the details describing this ADCS instance", description="get the some details like version, type, signing certificate chain, and templates configured of this ADCS instance", responses={@ApiResponse(responseCode="200", description="Details regarding this ADCS instance"), @ApiResponse(responseCode="401", description="authentication / authorization missing"), @ApiResponse(responseCode="503", description="ADCS server unavailable")})
    @RequestMapping(value={"/adcsInstanceDetails"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ADCSInstanceDetailsResponse> getCAInstanceDetails();
}

