/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.web.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import de.trustable.ca3s.adcs.proxy.service.JWSService;
import de.trustable.ca3s.adcs.proxy.web.dto.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcs.proxy.web.dto.CertificateRequestElements;
import de.trustable.ca3s.adcs.proxy.web.rest.AdcsCertificateBuilderApi;
import de.trustable.ca3s.adcs.proxy.web.rest.JWSWrappedRequest;
import de.trustable.ca3s.adcs.proxy.web.rest.LocalADCSService;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;

@Controller
public class AdcsCertificateBuilderApiController
implements AdcsCertificateBuilderApi {
    private static final Logger log = LoggerFactory.getLogger(AdcsCertificateBuilderApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;
    @Autowired
    private LocalADCSService localADCSService;
    @Autowired
    private JWSService jwsService;

    @Autowired
    public AdcsCertificateBuilderApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity<CertificateEnrollmentResponse> buildCertificate(@Parameter(description="CSR and additional attributes (e.g. template) wrapped in a JWS") @Valid @RequestBody JWSWrappedRequest body) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                log.debug("incoming JWS " + body);
                String payload = this.jwsService.getJWSPayload(body.getJws());
                CertificateRequestElements certRequest = (CertificateRequestElements)this.objectMapper.readValue(payload, CertificateRequestElements.class);
                CertificateEnrollmentResponse ceResp = this.localADCSService.requestCertificate(certRequest);
                return new ResponseEntity((Object)ceResp, HttpStatus.OK);
            }
            catch (ADCSException | IOException | GeneralSecurityException e) {
                log.error("Couldn't process request", e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (JOSEException | ParseException e) {
                log.error("Couldn't process JOSE element", e);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }
}

