/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.service.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class Problem {
    @JsonProperty(value="type")
    private URI type = URI.create("about:blank");
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="status")
    private Integer status;
    @JsonProperty(value="detail")
    private String detail;
    @JsonProperty(value="instance")
    private URI instance;

    public Problem type(URI type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", example="https://zalando.github.io/problem/constraint-violation", description="An absolute URI that identifies the problem type.  When dereferenced, it SHOULD provide human-readable documentation for the problem type (e.g., using HTML). ", required=false)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public Problem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="A short, summary of the problem type. Written in english and readable for engineers (usually not suited for non technical stakeholders and not localized); example: Service Unavailable ", required=false)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Problem status(Integer status) {
        this.status = status;
        return this;
    }

    @Min(value=100L)
    @Max(value=600L)
    @Schema(name="status", example="503", description="The HTTP status code generated by the origin server for this occurrence of the problem. ", required=false)
    public @Min(value=100L) @Max(value=600L) Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Problem detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Schema(name="detail", example="Connection to database timed out", description="A human readable explanation specific to this occurrence of the problem. ", required=false)
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Problem instance(URI instance) {
        this.instance = instance;
        return this;
    }

    @Valid
    @Schema(name="instance", description="An absolute URI that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced. ", required=false)
    public URI getInstance() {
        return this.instance;
    }

    public void setInstance(URI instance) {
        this.instance = instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && Objects.equals(this.status, problem.status) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.instance, problem.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Problem {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString((Object)this.detail)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString((Object)this.instance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

