/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.service;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Base64;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.annotation.PostConstruct;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JWSService {
    public static final String PREF_KEY = "de.trustable.ca3s.adcsproxy";
    public static final String PREF_KEY_SECRET = "de.trustable.ca3s.adcsproxy.secret";
    private static final Logger log = LoggerFactory.getLogger(JWSService.class);
    private final String secretPassphrase;
    private final String salt;
    private final int iterations;
    private final String apiKeySalt;
    private final int apiKeyIterations;
    private final String pbeAlgo;

    public JWSService(@Value(value="${adcs-proxy.connection.secret:#{null}}") String secretPassphrase, @Value(value="${adcs-proxy.connection.salt:ca3sSalt}") String salt, @Value(value="${adcs-proxy.connection.iterations:4567}") int iterations, @Value(value="${adcs-proxy.connection.api-key-salt:apiKeySalt}") String apiKeySalt, @Value(value="${adcs-proxy.connection.api-key-iterations:3756}") int apiKeyIterations, @Value(value="${adcs-proxy.connection.pbeAlgo:PBKDF2WithHmacSHA256}") String pbeAlgo) {
        this.secretPassphrase = secretPassphrase;
        this.salt = salt;
        this.iterations = iterations;
        this.apiKeySalt = apiKeySalt;
        this.apiKeyIterations = apiKeyIterations;
        this.pbeAlgo = pbeAlgo;
    }

    byte[] getSalt() {
        return this.salt.getBytes();
    }

    int getIterations() {
        return this.iterations;
    }

    byte[] getAPIKeySalt() {
        return this.apiKeySalt.getBytes();
    }

    int getAPIKeyIterations() {
        return this.apiKeyIterations;
    }

    public String getJWSPayload(String jwsAsString) throws JOSEException, ParseException, GeneralSecurityException {
        byte[] sharedSecret;
        MACVerifier verifier;
        JWSObject jwsObject = JWSObject.parse((String)jwsAsString);
        if (jwsObject.verify((JWSVerifier)(verifier = new MACVerifier(sharedSecret = this.getSharedSecret())))) {
            return jwsObject.getPayload().toString();
        }
        log.debug("jws '{}' failed verification", (Object)jwsAsString);
        throw new JOSEException("verification of JWS failed");
    }

    byte[] getSharedSecret() throws GeneralSecurityException {
        String passphrase = this.getPassphrase();
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), this.getSalt(), this.getIterations(), 256);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.pbeAlgo);
        return skf.generateSecret(spec).getEncoded();
    }

    public String getAPIKey() throws GeneralSecurityException {
        String passphrase = this.getPassphrase();
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), this.getAPIKeySalt(), this.getAPIKeyIterations(), 256);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.pbeAlgo);
        String apiKey = Base64.getEncoder().encodeToString(skf.generateSecret(spec).getEncoded());
        return apiKey;
    }

    private String getPassphrase() {
        String passphrase = "";
        if (this.secretPassphrase == null || this.secretPassphrase.trim().length() < 6) {
            log.warn("connection secret missing / too short!");
            return passphrase;
        }
        int passLen = this.secretPassphrase.length();
        log.debug("NOT FOR PRODUCTION: connection secret provided from command line / property file : '{}'", (Object)("*****" + this.secretPassphrase.substring(passLen - 3, passLen)));
        if (this.secretPassphrase != null) {
            passphrase = this.secretPassphrase;
            log.debug("connection secret provided from command line / property file. To take advantage of the registry key '{}', insert your secret in registry folder 'Computer\\\\HKEY_CURRENT_USER\\\\Software\\\\JavaSoft\\\\Prefs' !", (Object)PREF_KEY_SECRET);
        } else {
            Preferences userPref = Preferences.userRoot();
            passphrase = userPref.get(PREF_KEY_SECRET, null);
            if (passphrase == null) {
                log.warn("connection secret not available in registry entry '{}' !", (Object)PREF_KEY_SECRET);
                passphrase = this.createRandomString();
                userPref.put(PREF_KEY_SECRET, passphrase);
                log.info("new registry key '{}' populated with random secret", (Object)PREF_KEY_SECRET);
            } else {
                passLen = passphrase.length();
                log.debug("NOT FOR PRODUCTION: connection secret provided from registry : '{}'", (Object)("*****" + passphrase.substring(passLen - 3, passLen)));
            }
        }
        return passphrase;
    }

    public String createRandomString() {
        SecureRandom rnd = new SecureRandom();
        byte[] genSecret = new byte[16];
        ((Random)rnd).nextBytes(genSecret);
        return Base64.getEncoder().encodeToString(genSecret).toLowerCase().replaceAll("=", "");
    }

    @PostConstruct
    public void init() {
        try {
            this.getSharedSecret();
        }
        catch (GeneralSecurityException e) {
            log.warn("problem starting the JWSService", (Throwable)e);
        }
    }
}

